/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.net.URI;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.FileUtil;

@UriParams
public class GenericFileConfiguration {
    protected String directory;

    public boolean needToNormalize() {
        return true;
    }

    public void configure(URI uri) {
        String path = uri.getPath();
        path = FileUtil.stripFirstLeadingSeparator(path);
        this.setDirectory(path);
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        String string = this.directory = this.needToNormalize() ? FileUtil.normalizePath(directory) : directory;
        if (this.directory == null) {
            this.directory = "";
        }
    }

    public String toString() {
        return this.directory;
    }
}

