/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.runtime;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.runtime.CorbaObjectReader;
import org.apache.cxf.binding.corba.runtime.CorbaObjectWriter;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class CorbaStreamableImpl
implements CorbaStreamable {
    private CorbaObjectHandler value;
    private QName name;
    private int mode;
    private TypeCode typecode;

    public CorbaStreamableImpl(CorbaObjectHandler obj, QName elName) {
        this.value = obj;
        this.name = elName;
        this.typecode = obj.getTypeCode();
        this.mode = 2;
    }

    public void _read(InputStream istream) {
        try {
            CorbaObjectReader reader = new CorbaObjectReader(istream);
            reader.read(this.value);
        }
        catch (Exception ex) {
            throw new CorbaBindingException("Error reading streamable value", ex);
        }
    }

    public void _write(OutputStream ostream) {
        try {
            CorbaObjectWriter writer = new CorbaObjectWriter(ostream);
            writer.write(this.value);
        }
        catch (Exception ex) {
            throw new CorbaBindingException("Error writing streamable value", ex);
        }
    }

    public TypeCode _type() {
        return this.typecode;
    }

    @Override
    public CorbaObjectHandler getObject() {
        return this.value;
    }

    @Override
    public void setObject(CorbaObjectHandler obj) {
        this.value = obj;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int md) {
        this.mode = md;
    }

    @Override
    public String getName() {
        return this.name.getLocalPart();
    }
}

