/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.Random;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;

public class RandomUtil {
    protected static final Random random = new Random();
    private static final String letters = "abcdefghijklmnopqrstuvwxyz";
    private static final String digits = "0123456789";
    private static final String randomBase = "abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "0123456789";
    private static final int randomBaseLength = randomBase.length();

    public static Random getRandom() {
        return random;
    }

    public static String randomAlphaNumericString(int length) {
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            result.append(RandomUtil.randomChar());
        }
        return result.toString();
    }

    public static String randomUUIDString() {
        return UUID.randomUUID().toString();
    }

    public static SimpleString randomUUIDSimpleString() {
        return SimpleString.of(RandomUtil.randomUUIDString());
    }

    public static char randomChar() {
        return randomBase.charAt(random.nextInt(randomBaseLength));
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static long randomPositiveLong() {
        return Math.abs(RandomUtil.randomLong());
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomPositiveInt() {
        return Math.abs(RandomUtil.randomInt());
    }

    public static Integer randomPositiveIntOrNull() {
        Integer random = RandomUtil.randomInt();
        return random % 5 == 0 ? null : Integer.valueOf(Math.abs(random));
    }

    public static ActiveMQBuffer randomBuffer(int size, long ... data) {
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer(size + 8 * data.length);
        for (long d : data) {
            buffer.writeLong(d);
        }
        for (int i = 0; i < size; ++i) {
            buffer.writeByte(RandomUtil.randomByte());
        }
        return buffer;
    }

    public static int randomInterval(int min, int max) {
        if (min == max) {
            return max;
        }
        return min + random.nextInt(max - min);
    }

    public static int randomMax(int max) {
        assert (max > 0);
        int value = RandomUtil.randomPositiveInt() % max;
        if (value == 0) {
            value = max;
        }
        return value;
    }

    public static int randomPort() {
        return random.nextInt(65536);
    }

    public static short randomShort() {
        return (short)random.nextInt(Short.MAX_VALUE);
    }

    public static byte randomByte() {
        return Integer.valueOf(random.nextInt()).byteValue();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static byte[] randomBytes() {
        return RandomUtil.randomUUIDString().getBytes();
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = RandomUtil.randomByte();
        }
        return bytes;
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static String[] randomWords(int wordCount) {
        String[] words = new String[wordCount];
        for (int i = 0; i < wordCount; ++i) {
            words[i] = RandomUtil.randomAlphaNumericString(RandomUtil.randomPositiveInt() % 10 + 1);
        }
        return words;
    }
}

