/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.syntax.Token;

public class PrefixExpression
extends Expression {
    private final Token operation;
    private Expression expression;

    public PrefixExpression(Token operation, Expression expression) {
        this.operation = operation;
        this.setExpression(expression);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Token getOperation() {
        return this.operation;
    }

    @Override
    public String getText() {
        return "(" + this.getOperation().getText() + this.getExpression().getText() + ")";
    }

    @Override
    public ClassNode getType() {
        return this.getExpression().getType();
    }

    public String toString() {
        return super.toString() + "[" + this.getOperation() + this.getExpression() + "]";
    }

    @Override
    public Expression transformExpression(ExpressionTransformer transformer) {
        PrefixExpression ret = new PrefixExpression(this.getOperation(), transformer.transform(this.getExpression()));
        ret.setSourcePosition(this);
        ret.copyNodeMetaData(this);
        return ret;
    }

    @Override
    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitPrefixExpression(this);
    }
}

