/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.server.scheduler;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.retain.rpc.proto.RetainReply;
import org.apache.bifromq.retain.rpc.proto.RetainRequest;
import org.apache.bifromq.retain.rpc.proto.RetainResult;
import org.apache.bifromq.retain.rpc.proto.RetainServiceRWCoProcInput;
import org.apache.bifromq.retain.server.scheduler.BatchRetainCallHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRetainCall
extends BatchMutationCall<RetainRequest, RetainReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchRetainCall.class);

    protected BatchRetainCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<RetainRequest, RetainReply, MutationCallBatcherKey>> callTasks) {
        Iterator<RetainRequest> retainRequestIterator = Iterables.transform(callTasks, ICallTask::call).iterator();
        return RWCoProcInput.newBuilder().setRetainService(RetainServiceRWCoProcInput.newBuilder().setBatchRetain(BatchRetainCallHelper.makeBatch(retainRequestIterator)).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<RetainRequest, RetainReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<RetainRequest, RetainReply, MutationCallBatcherKey> task;
        while ((task = batchedTasks.poll()) != null) {
            RetainReply.Builder replyBuilder = RetainReply.newBuilder().setReqId(((RetainRequest)task.call()).getReqId());
            Map resultMap = output.getRetainService().getBatchRetain().getResultsMap();
            RetainResult topicMap = (RetainResult)resultMap.get(((RetainRequest)task.call()).getPublisher().getTenantId());
            if (topicMap == null) {
                log.error("tenantId not found in result map, tenantId: {}", (Object)((RetainRequest)task.call()).getPublisher().getTenantId());
                task.resultPromise().complete(replyBuilder.setResult(RetainReply.Result.ERROR).build());
                continue;
            }
            RetainResult.Code result = (RetainResult.Code)topicMap.getResultsMap().get(((RetainRequest)task.call()).getTopic());
            if (result == null) {
                log.error("topic not found in result map, tenantId: {}, topic: {}", (Object)((RetainRequest)task.call()).getPublisher().getTenantId(), (Object)((RetainRequest)task.call()).getTopic());
                task.resultPromise().complete(replyBuilder.setResult(RetainReply.Result.ERROR).build());
                continue;
            }
            switch (result) {
                case RETAINED: {
                    replyBuilder.setResult(RetainReply.Result.RETAINED);
                    break;
                }
                case CLEARED: {
                    replyBuilder.setResult(RetainReply.Result.CLEARED);
                    break;
                }
                default: {
                    log.error("unknown result code:{}", (Object)result);
                    replyBuilder.setResult(RetainReply.Result.ERROR);
                }
            }
            task.resultPromise().complete(replyBuilder.build());
        }
    }

    protected void handleException(ICallTask<RetainRequest, RetainReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(RetainReply.newBuilder().setReqId(((RetainRequest)callTask.call()).getReqId()).setResult(RetainReply.Result.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(RetainReply.newBuilder().setReqId(((RetainRequest)callTask.call()).getReqId()).setResult(RetainReply.Result.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(RetainReply.newBuilder().setReqId(((RetainRequest)callTask.call()).getReqId()).setResult(RetainReply.Result.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }
}

