/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.base.util;

import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CompletableFutureUtil {
    public static <T> BiConsumer<T, Throwable> unwrap(BiConsumer<T, Throwable> action) {
        return (res, ex) -> {
            Throwable real = ex instanceof CompletionException && ex.getCause() != null ? ex.getCause() : ex;
            action.accept(res, real);
        };
    }

    public static <T, U> BiFunction<T, Throwable, U> unwrap(BiFunction<T, Throwable, U> fn) {
        return (res, ex) -> {
            Throwable real = ex instanceof CompletionException && ex.getCause() != null ? ex.getCause() : ex;
            return fn.apply(res, real);
        };
    }

    public static <T> Function<Throwable, T> unwrap(Function<Throwable, T> action) {
        return ex -> {
            Throwable real = ex instanceof CompletionException && ex.getCause() != null ? ex.getCause() : ex;
            return action.apply(real);
        };
    }
}

