/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

class EventHistoryUtil {
    EventHistoryUtil() {
    }

    static NavigableMap<Long, Long> common(NavigableMap<Long, Long> historyA, NavigableMap<Long, Long> historyB) {
        TreeMap commonHistory = Maps.newTreeMap();
        for (Map.Entry br : historyB.entrySet()) {
            long bStartKey = (Long)br.getKey();
            long bEndKey = (Long)br.getValue();
            Long aStartKey = null;
            if (historyA.floorKey(bStartKey) != null) {
                aStartKey = historyA.floorKey(bStartKey);
            } else if (historyA.ceilingKey(bStartKey) != null) {
                aStartKey = historyA.ceilingKey(bStartKey);
            }
            while (aStartKey != null) {
                Long aEndKey = (Long)historyA.get(aStartKey);
                if (aStartKey <= bStartKey) {
                    if (bStartKey <= aEndKey) {
                        if (bEndKey <= aEndKey) {
                            commonHistory.put(bStartKey, bEndKey);
                            aStartKey = null;
                            continue;
                        }
                        commonHistory.put(bStartKey, aEndKey);
                        aStartKey = historyA.higherKey(aStartKey);
                        continue;
                    }
                    aStartKey = null;
                    continue;
                }
                if (bEndKey >= aStartKey) {
                    if (aEndKey <= bEndKey) {
                        commonHistory.put(aStartKey, aEndKey);
                        aStartKey = historyA.higherKey(aStartKey);
                        continue;
                    }
                    commonHistory.put(aStartKey, bEndKey);
                    aStartKey = null;
                    continue;
                }
                aStartKey = null;
            }
        }
        return commonHistory;
    }

    static NavigableMap<Long, Long> diff(NavigableMap<Long, Long> historyA, NavigableMap<Long, Long> historyB) {
        historyA = Maps.newTreeMap(historyA);
        for (Map.Entry br : historyB.entrySet()) {
            long bStartKey = (Long)br.getKey();
            long bEndKey = (Long)br.getValue();
            Long aStartKey = null;
            if (historyA.floorKey(bStartKey) != null) {
                aStartKey = historyA.floorKey(bStartKey);
            } else if (historyA.ceilingKey(bStartKey) != null) {
                aStartKey = historyA.ceilingKey(bStartKey);
            }
            while (aStartKey != null) {
                Long aEndKey = (Long)historyA.get(aStartKey);
                if (aStartKey <= bStartKey) {
                    if (bStartKey <= aEndKey) {
                        if (bEndKey <= aEndKey) {
                            historyA.remove(aStartKey);
                            if (aStartKey < bStartKey) {
                                historyA.put(aStartKey, bStartKey - 1L);
                            }
                            if (bEndKey < aEndKey) {
                                historyA.put(bEndKey + 1L, aEndKey);
                            }
                            aStartKey = null;
                            continue;
                        }
                        historyA.remove(aStartKey);
                        if (aStartKey < bStartKey) {
                            historyA.put(aStartKey, bStartKey - 1L);
                        }
                        aStartKey = historyA.ceilingKey(bStartKey);
                        continue;
                    }
                    aStartKey = historyA.higherKey(aStartKey);
                    continue;
                }
                if (aStartKey <= bEndKey) {
                    if (aEndKey <= bEndKey) {
                        historyA.remove(aStartKey);
                        aStartKey = historyA.higherKey(aStartKey);
                        continue;
                    }
                    historyA.remove(aStartKey);
                    historyA.put(bEndKey + 1L, aEndKey);
                    aStartKey = null;
                    continue;
                }
                aStartKey = null;
            }
        }
        return historyA;
    }

    static boolean isRemembering(Map<ByteString, NavigableMap<Long, Long>> eventIndex, ByteString replicaId, long ver) {
        NavigableMap ranges = eventIndex.getOrDefault(replicaId, Collections.emptyNavigableMap());
        Long key = ranges.floorKey(ver);
        return key != null && (Long)ranges.get(key) >= ver;
    }

    static void forget(Map<ByteString, NavigableMap<Long, Long>> historyMap, ByteString replicaId, long ver) {
        historyMap.computeIfPresent(replicaId, (k, v) -> {
            Map.Entry b = v.floorEntry(ver);
            if (b != null && ver <= (Long)b.getValue()) {
                v.remove(b.getKey());
                if (b.getKey() <= ver - 1L) {
                    v.put(b.getKey(), ver - 1L);
                }
                if (ver + 1L <= (Long)b.getValue()) {
                    v.put(ver + 1L, (Long)b.getValue());
                }
            }
            if (v.isEmpty()) {
                v = null;
            }
            return v;
        });
    }
}

