/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.store;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDT;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDTInflater;
import org.apache.bifromq.basecrdt.store.AntiEntropy;
import org.apache.bifromq.basecrdt.store.NeighborMessage;
import org.apache.bifromq.basecrdt.store.proto.AckMessage;
import org.apache.bifromq.basecrdt.store.proto.DeltaMessage;
import org.apache.bifromq.basecrdt.util.Formatter;
import org.apache.bifromq.basecrdt.util.ProtoUtil;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

final class AntiEntropyManager {
    private final String storeId;
    private final Logger log;
    private final ByteString localAddr;
    private final ICausalCRDTInflater<?, ?> crdtInflater;
    private final Subject<NeighborMessage> neighborMessageSubject = PublishSubject.create();
    private final ScheduledExecutorService executor;
    private final Map<ByteString, AntiEntropy> neighborMap = Maps.newConcurrentMap();
    private final int maxEventsInDelta;
    private final CompositeDisposable disposable = new CompositeDisposable();
    private final MetricManager metricManager;

    public AntiEntropyManager(String storeId, ByteString localAddr, ICausalCRDTInflater<?, ?> crdtInflater, ScheduledExecutorService executor, int maxEventsInDelta, String ... tags) {
        this.storeId = storeId;
        this.localAddr = localAddr;
        this.log = MDCLogger.getLogger(AntiEntropyManager.class, (String[])new String[]{"store", storeId, "replica", Formatter.print(crdtInflater.id())});
        this.crdtInflater = crdtInflater;
        this.executor = executor;
        this.maxEventsInDelta = maxEventsInDelta;
        this.metricManager = new MetricManager(Tags.of((String[])tags).and("replica.uri", crdtInflater.id().getUri()).and("replica.id", BaseEncoding.base64().encode(crdtInflater.id().getId().toByteArray())));
    }

    ByteString localAddr() {
        return this.localAddr;
    }

    <O extends ICRDTOperation, C extends ICausalCRDT<O>> C crdt() {
        return (C)this.crdtInflater.getCRDT();
    }

    Observable<NeighborMessage> neighborMessages() {
        return this.neighborMessageSubject;
    }

    CompletableFuture<AckMessage> receive(DeltaMessage delta, ByteString sender) {
        this.log.trace("Local[{}] receive delta[{}] from addr[{}]:\n{}", new Object[]{Formatter.toPrintable(this.localAddr), delta.getSeqNo(), Formatter.toPrintable(sender), Formatter.toPrintable(delta)});
        return this.handleDelta(delta, sender).thenApply(ack -> {
            this.metricManager.sendAckNum.increment();
            this.metricManager.sendAckBytes.increment((double)ack.getSerializedSize());
            this.log.trace("Local[{}] send ack[{}] to addr[{}]:\n{}", new Object[]{Formatter.toPrintable(this.localAddr), ack.getSeqNo(), Formatter.toPrintable(sender), Formatter.toPrintable(ack)});
            return ack;
        });
    }

    private CompletableFuture<AckMessage> handleDelta(DeltaMessage delta, ByteString sender) {
        this.metricManager.receiveDeltaNum.increment();
        this.metricManager.receiveDeltaBytes.increment((double)delta.getSerializedSize());
        AntiEntropy neighborAntiEntropy = this.neighborMap.get(sender);
        if (neighborAntiEntropy != null) {
            neighborAntiEntropy.updateObservedNeighborHistory(delta.getVer(), ProtoUtil.to(delta.getLatticeEventsList()), ProtoUtil.to(delta.getHistoryEventsList()));
        }
        if (delta.getReplacementList().isEmpty()) {
            return CompletableFuture.completedFuture(AckMessage.newBuilder().setSeqNo(delta.getSeqNo()).addAllLatticeEvents(ProtoUtil.to(this.crdtInflater.latticeEvents())).addAllHistoryEvents(ProtoUtil.to(this.crdtInflater.historyEvents())).setVer(HLC.INST.get()).build());
        }
        return this.crdtInflater.join(delta.getReplacementList()).thenApply(v -> AckMessage.newBuilder().setSeqNo(delta.getSeqNo()).addAllLatticeEvents(ProtoUtil.to(this.crdtInflater.latticeEvents())).addAllHistoryEvents(ProtoUtil.to(this.crdtInflater.historyEvents())).setVer(HLC.INST.get()).build());
    }

    void receive(AckMessage ack, ByteString neighborAddr) {
        this.metricManager.receiveAckNum.increment();
        this.metricManager.receiveAckBytes.increment((double)ack.getSerializedSize());
        AntiEntropy neighborAntiEntropy = this.neighborMap.get(neighborAddr);
        if (neighborAntiEntropy != null) {
            this.log.trace("Local[{}] receive ack[{}] from addr[{}]:\n{}", new Object[]{Formatter.toPrintable(this.localAddr), ack.getSeqNo(), Formatter.toPrintable(neighborAddr), Formatter.toPrintable(ack)});
            neighborAntiEntropy.handleAck(ack);
        } else {
            this.log.debug("Local[{}] ignore ack[{}] from addr[{}]:\n{}", new Object[]{Formatter.toPrintable(this.localAddr), ack.getSeqNo(), Formatter.toPrintable(neighborAddr), Formatter.toPrintable(ack)});
        }
    }

    void setNeighbors(Set<ByteString> neighborAddrs) {
        HashSet newNeighbors = Sets.newHashSet((Iterable)Sets.difference(neighborAddrs, this.neighborMap.keySet()));
        HashSet delNeighbors = Sets.newHashSet((Iterable)Sets.difference(this.neighborMap.keySet(), neighborAddrs));
        for (ByteString newNeighborAddr : newNeighbors) {
            this.log.trace("Local[{}] add new neighbor[{}]", Formatter.toPrintable(this.localAddr), Formatter.toPrintable(newNeighborAddr));
            this.neighborMap.put(newNeighborAddr, new AntiEntropy(this.storeId, this.localAddr, newNeighborAddr, this.crdtInflater, this.neighborMessageSubject, this.executor, this.maxEventsInDelta, this.metricManager.sendDeltaNum, this.metricManager.sendDeltaBytes));
        }
        for (ByteString delNeighbor : delNeighbors) {
            this.log.trace("Local[{}] remove neighbor[{}]", Formatter.toPrintable(this.localAddr), Formatter.toPrintable(delNeighbor));
            this.neighborMap.remove(delNeighbor).cancel();
        }
    }

    CompletableFuture<Void> stop() {
        this.log.debug("Stop anti-entropy manager");
        this.neighborMap.values().forEach(AntiEntropy::cancel);
        this.neighborMessageSubject.onComplete();
        this.disposable.dispose();
        this.metricManager.close();
        return this.crdtInflater.stop();
    }

    private class MetricManager {
        private final Counter sendDeltaNum;
        private final Counter sendDeltaBytes;
        private final Counter receiveDeltaNum;
        private final Counter receiveDeltaBytes;
        private final Counter sendAckNum;
        private final Counter sendAckBytes;
        private final Counter receiveAckNum;
        private final Counter receiveAckBytes;
        private final Set<Meter> meters = new HashSet<Meter>();

        MetricManager(Tags tags) {
            this.meters.add((Meter)Gauge.builder((String)"basecrdt.neighbor", AntiEntropyManager.this.neighborMap, Map::size).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry));
            this.sendDeltaNum = Metrics.counter((String)"basecrdt.send.delta.count", (Iterable)tags);
            this.sendDeltaBytes = Metrics.counter((String)"basecrdt.send.delta.bytes", (Iterable)tags);
            this.receiveDeltaNum = Metrics.counter((String)"basecrdt.receive.delta.count", (Iterable)tags);
            this.receiveDeltaBytes = Metrics.counter((String)"basecrdt.receive.delta.bytes", (Iterable)tags);
            this.sendAckNum = Metrics.counter((String)"basecrdt.send.ack.count", (Iterable)tags);
            this.sendAckBytes = Metrics.counter((String)"basecrdt.send.ack.bytes", (Iterable)tags);
            this.receiveAckNum = Metrics.counter((String)"basecrdt.receive.ack.count", (Iterable)tags);
            this.receiveAckBytes = Metrics.counter((String)"basecrdt.receive.ack.bytes", (Iterable)tags);
        }

        void close() {
            this.meters.forEach(meter -> Metrics.globalRegistry.removeByPreFilterId(meter.getId()));
            Metrics.globalRegistry.removeByPreFilterId(this.sendAckNum.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.sendAckBytes.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.receiveAckNum.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.receiveAckBytes.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.sendDeltaNum.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.sendDeltaBytes.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.receiveDeltaNum.getId());
            Metrics.globalRegistry.removeByPreFilterId(this.receiveDeltaBytes.getId());
        }
    }
}

