/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesObserver;
import org.apache.bifromq.basekv.proto.BalancerStateSnapshot;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVStoreBalancerStatesObserver
implements IBaseKVStoreBalancerStatesObserver {
    private final Logger log;
    private final BehaviorSubject<Map<String, Map<String, BalancerStateSnapshot>>> currentBalancerStatesSubject = BehaviorSubject.createDefault(Collections.emptyMap());
    private final CompositeDisposable disposable = new CompositeDisposable();

    BaseKVStoreBalancerStatesObserver(IBaseKVStoreBalancerStatesCRDT statesCRDT) {
        this.log = MDCLogger.getLogger(BaseKVStoreBalancerStatesObserver.class, (String[])new String[]{"clusterId", statesCRDT.clusterId()});
        this.disposable.add(statesCRDT.currentBalancerStates().observeOn(IBaseKVMetaService.SHARED_SCHEDULER).map(statesMap -> {
            HashMap currentStates = new HashMap();
            statesMap.forEach((storeKey, balancerStates) -> currentStates.compute(storeKey.getStoreId(), (k, v) -> {
                if (v == null) {
                    return balancerStates;
                }
                if (this.greatestHLC((Map<String, BalancerStateSnapshot>)v) >= this.greatestHLC((Map<String, BalancerStateSnapshot>)balancerStates)) {
                    return v;
                }
                return balancerStates;
            }));
            this.log.debug("Current balancer states changed: {}", currentStates);
            return currentStates;
        }).subscribe(arg_0 -> this.currentBalancerStatesSubject.onNext(arg_0)));
    }

    private long greatestHLC(Map<String, BalancerStateSnapshot> balancerStates) {
        return balancerStates.values().stream().mapToLong(BalancerStateSnapshot::getHlc).max().orElse(0L);
    }

    @Override
    public Observable<Map<String, Map<String, BalancerStateSnapshot>>> currentBalancerStates() {
        return this.currentBalancerStatesSubject.distinctUntilChanged();
    }

    @Override
    public void stop() {
        this.disposable.dispose();
        this.currentBalancerStatesSubject.onComplete();
    }
}

