/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.basecluster.AgentHostOptions;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basecluster.agent.proto.AgentEndpoint;
import org.apache.bifromq.basecluster.fd.FailureDetector;
import org.apache.bifromq.basecluster.fd.IProbingTarget;
import org.apache.bifromq.basecluster.memberlist.AutoDropper;
import org.apache.bifromq.basecluster.memberlist.AutoHealer;
import org.apache.bifromq.basecluster.memberlist.AutoSeeder;
import org.apache.bifromq.basecluster.memberlist.CRDTUtil;
import org.apache.bifromq.basecluster.memberlist.HostMemberList;
import org.apache.bifromq.basecluster.memberlist.IHostAddressResolver;
import org.apache.bifromq.basecluster.memberlist.IHostMemberList;
import org.apache.bifromq.basecluster.memberlist.MemberSelector;
import org.apache.bifromq.basecluster.memberlist.agent.IAgent;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.messenger.IMessenger;
import org.apache.bifromq.basecluster.messenger.MessageEnvelope;
import org.apache.bifromq.basecluster.messenger.Messenger;
import org.apache.bifromq.basecluster.messenger.MessengerOptions;
import org.apache.bifromq.basecluster.proto.ClusterMessage;
import org.apache.bifromq.basecluster.transport.ITransport;
import org.apache.bifromq.basecrdt.store.CRDTStoreOptions;
import org.apache.bifromq.basecrdt.store.ICRDTStore;
import org.apache.bifromq.basecrdt.store.proto.CRDTStoreMessage;
import org.apache.bifromq.baseenv.EnvProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AgentHost
implements IAgentHost {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentHost.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final AgentHostOptions options;
    private final ICRDTStore store;
    private final ITransport transport;
    private final IMessenger messenger;
    private final IHostMemberList memberList;
    private final Scheduler hostScheduler;
    private final MemberSelector memberSelector;
    private final AutoHealer healer;
    private final AutoSeeder seeder;
    private final AutoDropper deadDropper;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final IHostAddressResolver hostAddressResolver;
    private final String[] tags;

    AgentHost(ITransport transport, IHostAddressResolver resolver, AgentHostOptions options) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)options.addr()) && !"0.0.0.0".equals(options.addr()) ? 1 : 0) != 0, (Object)"Invalid bind address");
        this.transport = transport;
        this.options = options.toBuilder().build();
        MessengerOptions messengerOptions = new MessengerOptions();
        messengerOptions.maxFanout(options.gossipFanout()).maxFanoutGossips(options.gossipFanoutPerPeriod()).maxHealthScore(options.awarenessMaxMultiplier()).retransmitMultiplier(options.retransmitMultiplier()).spreadPeriod(options.gossipPeriod());
        this.hostScheduler = Schedulers.from((Executor)ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, EnvProvider.INSTANCE.newThreadFactory("agent-host-scheduler", true)), (String)"agent-host-scheduler", (Tag[])new Tag[0]));
        this.store = ICRDTStore.newInstance((CRDTStoreOptions)options.crdtStoreOptions());
        this.messenger = Messenger.builder().transport(transport).opts(messengerOptions).scheduler(this.hostScheduler).build();
        this.hostAddressResolver = resolver;
        this.store.start(this.messenger.receive().filter(m -> ((MessageEnvelope)m.value()).message.hasCrdtStoreMessage()).map(m -> ((MessageEnvelope)m.value()).message.getCrdtStoreMessage()));
        this.tags = new String[]{"local", options.addr() + ":" + this.messenger.bindAddress().getPort()};
        this.memberList = new HostMemberList(options.addr(), this.messenger.bindAddress().getPort(), this.messenger, this.hostScheduler, this.store, this.hostAddressResolver, this.tags);
        FailureDetector failureDetector = FailureDetector.builder().local(new IProbingTarget(){

            @Override
            public ByteString id() {
                return AgentHost.this.memberList.local().getEndpoint().toByteString();
            }

            @Override
            public InetSocketAddress addr() {
                return AgentHost.this.messenger.bindAddress();
            }
        }).baseProbeInterval(options.baseProbeInterval()).baseProbeTimeout(options.baseProbeTimeout()).indirectProbes(options.indirectProbes()).worstHealthScore(options.awarenessMaxMultiplier()).messenger(this.messenger).scheduler(this.hostScheduler).build();
        this.healer = new AutoHealer(this.messenger, this.hostScheduler, this.memberList, this.hostAddressResolver, options.autoHealingTimeout(), options.autoHealingInterval(), this.tags);
        this.seeder = new AutoSeeder(this.messenger, this.hostScheduler, this.memberList, this.hostAddressResolver, options.joinTimeout(), Duration.ofSeconds(options.joinRetryInSec()), this.tags);
        this.deadDropper = new AutoDropper(this.messenger, this.hostScheduler, this.memberList, failureDetector, this.hostAddressResolver, options.suspicionMultiplier(), options.suspicionMaxTimeoutMultiplier(), this.tags);
        this.memberSelector = new MemberSelector(this.memberList, this.hostScheduler, this.hostAddressResolver);
        this.disposables.add(this.store.storeMessages().subscribe(this::sendCRDTStoreMessage));
        this.start();
    }

    @Override
    public String env() {
        return this.options.env();
    }

    @Override
    public HostEndpoint local() {
        return this.memberList.local().getEndpoint();
    }

    @Override
    public CompletableFuture<Void> join(Set<InetSocketAddress> seeds) {
        return this.seeder.join(seeds);
    }

    @Override
    public IAgent host(String agentId) {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return this.memberList.host(agentId);
    }

    @Override
    public CompletableFuture<Void> stopHosting(String agentId) {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return this.memberList.stopHosting(agentId);
    }

    @Override
    public Observable<Set<HostEndpoint>> membership() {
        return this.memberList.members().map(Map::keySet);
    }

    @Override
    public Observable<Map<HostEndpoint, Set<String>>> landscape() {
        return this.memberList.landscape();
    }

    @Override
    public Observable<Long> refuteSignal() {
        return this.memberList.refuteSignal();
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            log.info("Stopping AgentHost");
            this.healer.stop();
            this.seeder.stop();
            this.deadDropper.stop();
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.memberList.stop().exceptionally(e -> null)).thenAccept(v -> {
                this.store.stop();
                this.messenger.shutdown();
            })).thenCompose(v -> this.transport.shutdown())).whenComplete((v, e) -> {
                this.memberSelector.stop();
                this.disposables.dispose();
                this.hostScheduler.shutdown();
                this.state.set(State.SHUTDOWN);
            })).join();
            log.debug("AgentHost stopped");
        }
    }

    private void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            this.messenger.start(this.memberSelector);
            this.deadDropper.start();
            this.state.set(State.STARTED);
        }
    }

    private void sendCRDTStoreMessage(CRDTStoreMessage storeMsg) {
        ClusterMessage msg = ClusterMessage.newBuilder().setCrdtStoreMessage(storeMsg).build();
        try {
            HostEndpoint endpoint = storeMsg.getUri().equals(CRDTUtil.AGENT_HOST_MAP_URI) ? HostEndpoint.parseFrom(storeMsg.getReceiver()) : AgentEndpoint.parseFrom(storeMsg.getReceiver()).getEndpoint();
            this.messenger.send(msg, this.hostAddressResolver.resolve(endpoint), false);
        }
        catch (Exception e) {
            log.error("Target Host[{}] not found:\n{}", (Object)storeMsg.getReceiver(), (Object)storeMsg);
        }
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        SHUTDOWN;

    }
}

