/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.dist.rpc.proto.DistServiceROCoProcInput;
import org.apache.bifromq.dist.rpc.proto.GCReply;
import org.apache.bifromq.dist.rpc.proto.GCRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DistWorkerCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistWorkerCleaner.class);
    private static final int MAX_STEP = 10;
    private static final int SCAN_QUOTA_BASE = 512;
    private static final int FIRST_SWEEP_SCAN_QUOTA = 50000;
    private static final Duration FIRST_SWEEP_INTERVAL = Duration.ofSeconds(5L);
    private static final double HIGH_SUCCESS_RATIO = 0.005;
    private static final int LOW_HIT_THRESHOLD = 3;
    private static final double QUOTA_HIT_RATIO = 0.8;
    private static final double GROWTH = 1.5;
    private static final double SHRINK = 2.0;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final IBaseKVStoreClient distWorkerClient;
    private final Duration minCleanInterval;
    private final Duration maxCleanInterval;
    private final ScheduledExecutorService jobScheduler;
    private final Clock clock;
    private final Map<KVRangeId, RangeGcState> rangeStates = new HashMap<KVRangeId, RangeGcState>();
    private volatile ScheduledFuture<?> cleanerFuture;

    DistWorkerCleaner(IBaseKVStoreClient distWorkerClient, Duration minCleanInterval, Duration maxCleanInterval, ScheduledExecutorService jobScheduler) {
        this(distWorkerClient, minCleanInterval, maxCleanInterval, jobScheduler, Clock.systemUTC());
    }

    DistWorkerCleaner(IBaseKVStoreClient distWorkerClient, Duration minCleanInterval, Duration maxCleanInterval, ScheduledExecutorService jobScheduler, Clock clock) {
        this.distWorkerClient = distWorkerClient;
        this.minCleanInterval = minCleanInterval;
        this.maxCleanInterval = maxCleanInterval;
        this.jobScheduler = jobScheduler;
        this.clock = clock;
    }

    void start(String storeId) {
        if (this.started.compareAndSet(false, true)) {
            log.info("DistWorkerCleaner started");
            this.doStart(storeId);
        }
    }

    CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            this.cleanerFuture.cancel(true);
            CompletableFuture<Void> onDone = new CompletableFuture<Void>();
            this.jobScheduler.execute(() -> {
                log.info("DistWorkerCleaner stopped");
                for (RangeGcState st : this.rangeStates.values()) {
                    if (st.stepGauge != null) {
                        Metrics.globalRegistry.removeByPreFilterId(st.stepGauge.getId());
                    }
                    if (st.intervalGauge == null) continue;
                    Metrics.globalRegistry.removeByPreFilterId(st.intervalGauge.getId());
                }
                onDone.complete(null);
            });
            return onDone;
        }
        return CompletableFuture.completedFuture(null);
    }

    private void doStart(String storeId) {
        if (!this.started.get()) {
            return;
        }
        Instant now = this.clock.instant();
        Duration chosenDelay = null;
        boolean anyDueNow = false;
        for (RangeGcState state : this.rangeStates.values()) {
            if (state.nextDue.isAfter(now)) {
                Duration d = Duration.between(now, state.nextDue);
                if (chosenDelay != null && d.compareTo(chosenDelay) >= 0) continue;
                chosenDelay = d;
                continue;
            }
            anyDueNow = true;
        }
        Duration delay = anyDueNow ? Duration.ZERO : (chosenDelay != null ? chosenDelay : this.minCleanInterval);
        log.debug("DistWorkerCleaner next round in {} ms", (Object)delay.toMillis());
        this.cleanerFuture = this.jobScheduler.schedule(() -> this.doGC(storeId).thenRun(() -> this.doStart(storeId)), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private CompletableFuture<Void> doGC(String storeId) {
        List<KVRangeSetting> leaders = KVRangeRouterUtil.findByBoundary((Boundary)BoundaryUtil.FULL_BOUNDARY, (NavigableMap)this.distWorkerClient.latestEffectiveRouter()).stream().filter(r -> r.leader().equals(storeId)).toList();
        HashMap<KVRangeId, KVRangeSetting> currentLeaderMap = new HashMap<KVRangeId, KVRangeSetting>();
        for (KVRangeSetting rs2 : leaders) {
            currentLeaderMap.put(rs2.id(), rs2);
            RangeGcState state = this.rangeStates.get(rs2.id());
            if (state == null) {
                state = new RangeGcState();
                state.step = 1;
                state.interval = FIRST_SWEEP_INTERVAL;
                state.lowRatioHits = 0;
                state.nextDue = Instant.EPOCH;
                state.ver = rs2.ver();
                state.boundary = rs2.boundary();
                state.wrappedOnce = false;
                state.sprinted = false;
                Tags tags = Tags.of((String)"storeId", (String)storeId).and("rangeId", KVRangeIdUtil.toString((KVRangeId)rs2.id()));
                state.intervalGauge = Gauge.builder((String)"dist.gc.interval.ms", (Object)state, s -> s.interval.toMillis()).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
                state.stepGauge = Gauge.builder((String)"dist.gc.step", (Object)state, s -> s.step).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
                this.rangeStates.put(rs2.id(), state);
                continue;
            }
            if (state.ver == rs2.ver() && state.boundary.equals((Object)rs2.boundary())) continue;
            if (state.nextKey != null) {
                state.nextKey = BoundaryUtil.clampToBoundary((ByteString)state.nextKey, (Boundary)rs2.boundary());
            }
            state.step = 1;
            state.interval = state.sprinted ? this.minCleanInterval : FIRST_SWEEP_INTERVAL;
            state.lowRatioHits = 0;
            state.wrappedOnce = false;
            state.ver = rs2.ver();
            state.boundary = rs2.boundary();
        }
        this.rangeStates.entrySet().removeIf(e -> {
            boolean remove;
            boolean bl = remove = !currentLeaderMap.containsKey(e.getKey());
            if (remove) {
                RangeGcState st = (RangeGcState)e.getValue();
                if (st.stepGauge != null) {
                    Metrics.globalRegistry.removeByPreFilterId(st.stepGauge.getId());
                }
                if (st.intervalGauge != null) {
                    Metrics.globalRegistry.removeByPreFilterId(st.intervalGauge.getId());
                }
            }
            return remove;
        });
        long reqId = HLC.INST.getPhysical();
        Instant now = this.clock.instant();
        List<CompletableFuture> futures = leaders.stream().map(rs -> {
            ByteString start;
            RangeGcState s = this.rangeStates.get(rs.id());
            if (s == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (s.nextDue.isAfter(now)) {
                return CompletableFuture.completedFuture(null);
            }
            GCRequest.Builder gcReq = GCRequest.newBuilder().setReqId(reqId).setStepHint(s.sprinted ? Math.max(1, s.step) : 1).setScanQuota(s.sprinted ? 512 * Math.max(1, s.step) : 50000);
            if (s.nextKey != null && (start = BoundaryUtil.clampToBoundary((ByteString)s.nextKey, (Boundary)rs.boundary())) != null) {
                gcReq.setStartKey(start);
            }
            String rangeIdStr = KVRangeIdUtil.toString((KVRangeId)rs.id());
            int stepHint = gcReq.getStepHint();
            int quota = gcReq.getScanQuota();
            log.debug("[DistWorker] start gc: reqId={}, rangeId={}, stepHint={}, quota={}", new Object[]{reqId, rangeIdStr, stepHint, quota});
            return this.distWorkerClient.query(rs.leader(), KVRangeRORequest.newBuilder().setReqId(reqId).setKvRangeId(rs.id()).setVer(rs.ver()).setRoCoProc(ROCoProcInput.newBuilder().setDistService(DistServiceROCoProcInput.newBuilder().setGc(gcReq.build()).build()).build()).build()).handle((v, e) -> {
                try {
                    if (e != null) {
                        log.debug("[DistWorker] gc error: reqId={}, rangeId={}", new Object[]{reqId, rangeIdStr, e});
                        this.onGCFailure(s);
                        Object var7_6 = null;
                        return var7_6;
                    }
                    if (v.getCode() != ReplyCode.Ok) {
                        log.debug("[DistWorker] gc rejected: reqId={}, rangeId={}, reason={}", new Object[]{reqId, rangeIdStr, v.getCode()});
                        this.onGCFailure(s);
                        Object var7_7 = null;
                        return var7_7;
                    }
                    GCReply reply = v.getRoCoProcResult().getDistService().getGc();
                    this.onGCSuccess(s, reply);
                    log.debug("[DistWorker] gc done: reqId={}, rangeId={}, inspected={}, removeSuccess={}, wrapped={}", new Object[]{reqId, rangeIdStr, reply.getInspectedCount(), reply.getRemoveSuccess(), reply.getWrapped()});
                }
                finally {
                    s.nextDue = this.clock.instant().plus(s.interval);
                }
                return null;
            });
        }).toList();
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private void onGCFailure(RangeGcState s) {
        s.step = 1;
        s.interval = s.sprinted ? this.minCleanInterval : FIRST_SWEEP_INTERVAL;
        s.lowRatioHits = 0;
        s.wrappedOnce = false;
    }

    private void onGCSuccess(RangeGcState s, GCReply reply) {
        boolean coverageOK;
        s.nextKey = reply.hasNextStartKey() ? BoundaryUtil.clampToBoundary((ByteString)reply.getNextStartKey(), (Boundary)s.boundary) : null;
        if (reply.getWrapped()) {
            s.wrappedOnce = true;
        }
        if (!s.sprinted) {
            if (reply.getWrapped()) {
                s.sprinted = true;
                s.step = 1;
                s.interval = this.minCleanInterval;
                s.lowRatioHits = 0;
                s.wrappedOnce = false;
            }
            return;
        }
        int inspected = reply.getInspectedCount();
        int removeSuccess = reply.getRemoveSuccess();
        double successRatio = inspected == 0 ? 0.0 : (double)removeSuccess / (double)inspected;
        int scanQuota = 512 * Math.max(1, s.step);
        boolean bl = coverageOK = s.wrappedOnce || inspected >= (int)((double)scanQuota * 0.8);
        if (successRatio >= 0.005) {
            s.step = Math.max(s.step / 2, 1);
            long shrunk = (long)((double)s.interval.toMillis() / 2.0);
            s.interval = Duration.ofMillis(Math.max(shrunk, this.minCleanInterval.toMillis()));
            s.lowRatioHits = 0;
            s.wrappedOnce = false;
        } else if (coverageOK && removeSuccess == 0) {
            ++s.lowRatioHits;
            if (s.lowRatioHits >= 3 && s.wrappedOnce) {
                if (inspected >= (int)((double)scanQuota * 0.8)) {
                    s.step = Math.min(s.step + 1, 10);
                }
                long grown = (long)((double)s.interval.toMillis() * 1.5);
                s.interval = Duration.ofMillis(Math.min(grown, this.maxCleanInterval.toMillis()));
                s.lowRatioHits = 0;
                s.wrappedOnce = false;
            }
        } else if (!s.wrappedOnce) {
            s.interval = this.minCleanInterval;
        }
    }

    private static class RangeGcState {
        ByteString nextKey;
        int step;
        Duration interval;
        int lowRatioHits;
        boolean wrappedOnce;
        Instant nextDue;
        long ver;
        Boundary boundary;
        boolean sprinted;
        Gauge stepGauge;
        Gauge intervalGauge;

        private RangeGcState() {
        }
    }
}

