/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageBuilders;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageUtils;
import org.apache.bifromq.mqtt.handler.v5.ReAuthenticator;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5DisconnectReasonCode;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ProtocolViolation;
import org.apache.bifromq.type.ClientInfo;

public interface IReAuthenticator {
    public static IReAuthenticator create(MqttConnectMessage connMsg, IAuthProvider authProvider, ClientInfo clientInfo, Consumer<ProtocolResponse> responder, Executor executor) {
        Optional<String> authMethodOpt = MQTT5MessageUtils.authMethod(connMsg.variableHeader().properties());
        if (authMethodOpt.isPresent()) {
            return new ReAuthenticator(clientInfo, authProvider, authMethodOpt.get(), responder, executor);
        }
        return msg -> {
            if (msg.fixedHeader().messageType() == MqttMessageType.AUTH) {
                responder.accept(ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Re-auth not supported").clientInfo(clientInfo)}));
            }
        };
    }

    public void onAuth(MqttMessage var1);
}

