/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.context;

import com.google.common.base.Splitter;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.context.DefaultRealmContextResolver;
import org.apache.polaris.service.context.RealmContextConfiguration;
import org.apache.polaris.service.context.RealmContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="test")
public class TestRealmContextResolver
implements RealmContextResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRealmContextResolver.class);
    public static final String REALM_PROPERTY_KEY = "realm";
    private final RealmContextConfiguration configuration;

    @Inject
    public TestRealmContextResolver(RealmContextConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public CompletionStage<RealmContext> resolveRealmContext(String requestURL, String method, String path, Function<String, String> headers) {
        LOGGER.debug("Resolving RealmContext for method: {}, path: {}, headers: {}", new Object[]{method, path, headers});
        Map<String, String> parsedProperties = TestRealmContextResolver.parseBearerTokenAsKvPairs(headers);
        String realm = headers.apply(REALM_PROPERTY_KEY);
        if (!parsedProperties.containsKey(REALM_PROPERTY_KEY) && realm != null) {
            parsedProperties.put(REALM_PROPERTY_KEY, realm);
        }
        if (!parsedProperties.containsKey(REALM_PROPERTY_KEY)) {
            LOGGER.warn("Failed to parse {} from headers; using {}", (Object)REALM_PROPERTY_KEY, (Object)this.configuration.defaultRealm());
            parsedProperties.put(REALM_PROPERTY_KEY, this.configuration.defaultRealm());
        }
        String realmId = parsedProperties.get(REALM_PROPERTY_KEY);
        return CompletableFuture.completedFuture(() -> realmId);
    }

    private static Map<String, String> parseBearerTokenAsKvPairs(Function<String, String> headers) {
        String[] parts;
        String authHeader;
        HashMap<String, String> parsedProperties = new HashMap<String, String>();
        if (headers != null && (authHeader = headers.apply("Authorization")) != null && (parts = authHeader.split(" ")).length == 2 && "Bearer".equalsIgnoreCase(parts[0]) && parts[1].matches("[\\w\\d=_+-]+:[\\w\\d=+_-]+(?:;[\\w\\d=+_-]+:[\\w\\d=+_-]+)*")) {
            parsedProperties.putAll(Splitter.on((char)';').trimResults().withKeyValueSeparator(':').split((CharSequence)parts[1]));
        }
        return parsedProperties;
    }
}

