/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.polaris.service.types.ApplicablePolicy;

public class GetApplicablePoliciesResponse {
    private final String nextPageToken;
    @NotNull
    @Valid
    private final Set<ApplicablePolicy> applicablePolicies;

    @ApiModelProperty(value="An opaque token that allows clients to make use of pagination for list APIs (e.g. ListTables). Clients may initiate the first paginated request by sending an empty query parameter `pageToken` to the server. Servers that support pagination should identify the `pageToken` parameter and return a `next-page-token` in the response if there are more results available.  After the initial request, the value of `next-page-token` from each response must be used as the `pageToken` parameter value for the next request. The server must return `null` value for the `next-page-token` in the last response. Servers that support pagination must return all results in a single response with the value of `next-page-token` set to `null` if the query parameter `pageToken` is not set in the request. Servers that do not support pagination should ignore the `pageToken` parameter and return all results in a single response. The `next-page-token` must be omitted from the response. Clients must interpret either `null` or missing response value of `next-page-token` as the end of the listing results.")
    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="applicable-policies", required=true)
    public Set<ApplicablePolicy> getApplicablePolicies() {
        return this.applicablePolicies;
    }

    @JsonCreator
    public GetApplicablePoliciesResponse(@JsonProperty(value="next-page-token") String nextPageToken, @JsonProperty(value="applicable-policies", required=true) Set<ApplicablePolicy> applicablePolicies) {
        this.nextPageToken = nextPageToken;
        this.applicablePolicies = Objects.requireNonNullElse(applicablePolicies, new LinkedHashSet());
    }

    public GetApplicablePoliciesResponse(Set<ApplicablePolicy> applicablePolicies) {
        this.nextPageToken = null;
        this.applicablePolicies = Objects.requireNonNullElse(applicablePolicies, new LinkedHashSet());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Set<ApplicablePolicy> applicablePolicies) {
        return new Builder(applicablePolicies);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetApplicablePoliciesResponse getApplicablePoliciesResponse = (GetApplicablePoliciesResponse)o;
        return Objects.equals(this.nextPageToken, getApplicablePoliciesResponse.nextPageToken) && Objects.equals(this.applicablePolicies, getApplicablePoliciesResponse.applicablePolicies);
    }

    public int hashCode() {
        return Objects.hash(this.nextPageToken, this.applicablePolicies);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetApplicablePoliciesResponse {\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("    applicablePolicies: ").append(this.toIndentedString(this.applicablePolicies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String nextPageToken;
        private Set<ApplicablePolicy> applicablePolicies;

        private Builder() {
        }

        private Builder(Set<ApplicablePolicy> applicablePolicies) {
            this.applicablePolicies = Objects.requireNonNullElse(applicablePolicies, new LinkedHashSet());
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder setApplicablePolicies(Set<ApplicablePolicy> applicablePolicies) {
            this.applicablePolicies = applicablePolicies;
            return this;
        }

        public GetApplicablePoliciesResponse build() {
            GetApplicablePoliciesResponse inst = new GetApplicablePoliciesResponse(this.nextPageToken, this.applicablePolicies);
            return inst;
        }
    }
}

