/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.RetainedMessage;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.persistence.PropertiesDataType;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;

public class H2RetainedRepository
implements IRetainedRepository {
    private final MVMap<Topic, RetainedMessage> retainedMap;
    private final MVMap<Topic, RetainedMessage> retainedExpireMap;
    private final MVMap.Builder<Topic, RetainedMessage> retainedBuilder = new MVMap.Builder().valueType((DataType)new RetainedMessageValueType());

    public H2RetainedRepository(MVStore mvStore) {
        this.retainedMap = mvStore.openMap("retained_store", this.retainedBuilder);
        this.retainedExpireMap = mvStore.openMap("retained_expiry_store", this.retainedBuilder);
    }

    @Override
    public void cleanRetained(Topic topic) {
        this.retainedMap.remove((Object)topic);
        this.retainedExpireMap.remove((Object)topic);
    }

    @Override
    public void retain(Topic topic, MqttPublishMessage msg) {
        byte[] rawPayload = H2RetainedRepository.payloadToByteArray(msg);
        RetainedMessage toStore = new RetainedMessage(topic, msg.fixedHeader().qosLevel(), rawPayload, H2RetainedRepository.extractPropertiesArray(msg));
        this.retainedMap.put((Object)topic, (Object)toStore);
    }

    private static MqttProperties.MqttProperty[] extractPropertiesArray(MqttPublishMessage msg) {
        MqttProperties properties = msg.variableHeader().properties();
        return properties.listAll().toArray(new MqttProperties.MqttProperty[0]);
    }

    @Override
    public void retain(Topic topic, MqttPublishMessage msg, Instant expiryTime) {
        byte[] rawPayload = H2RetainedRepository.payloadToByteArray(msg);
        RetainedMessage toStore = new RetainedMessage(topic, msg.fixedHeader().qosLevel(), rawPayload, H2RetainedRepository.extractPropertiesArray(msg), expiryTime);
        this.retainedExpireMap.put((Object)topic, (Object)toStore);
    }

    private static byte[] payloadToByteArray(MqttPublishMessage msg) {
        ByteBuf payload = msg.content();
        byte[] rawPayload = new byte[payload.readableBytes()];
        payload.getBytes(0, rawPayload);
        return rawPayload;
    }

    @Override
    public boolean isEmpty() {
        return this.retainedMap.isEmpty() && this.retainedExpireMap.isEmpty();
    }

    @Override
    public Collection<RetainedMessage> retainedOnTopic(String topic) {
        Topic searchTopic = new Topic(topic);
        ArrayList<RetainedMessage> matchingMessages = new ArrayList<RetainedMessage>();
        matchingMessages.addAll(this.findMatching(searchTopic, this.retainedMap));
        matchingMessages.addAll(this.findMatching(searchTopic, this.retainedExpireMap));
        return matchingMessages;
    }

    private List<RetainedMessage> findMatching(Topic searchTopic, MVMap<Topic, RetainedMessage> mapToSearch) {
        ArrayList<RetainedMessage> matchingMessages = new ArrayList<RetainedMessage>();
        for (Map.Entry entry : mapToSearch.entrySet()) {
            Topic scanTopic = (Topic)entry.getKey();
            if (!scanTopic.match(searchTopic)) continue;
            matchingMessages.add((RetainedMessage)entry.getValue());
        }
        return matchingMessages;
    }

    @Override
    public Collection<RetainedMessage> listExpirable() {
        return this.retainedExpireMap.values();
    }

    private static final class RetainedMessageValueType
    extends BasicDataType<RetainedMessage> {
        private final PropertiesDataType propertiesDataType = new PropertiesDataType();
        private static final byte MESSAGE_EXPIRY_FLAG = 1;
        private static final byte PROPERTIES_FLAG = 2;

        private RetainedMessageValueType() {
        }

        public int getMemory(RetainedMessage retainedMsg) {
            int bytesSize = StringDataType.INSTANCE.getMemory(retainedMsg.getTopic().toString()) + 1 + 4 + retainedMsg.getPayload().length + 1;
            if (retainedMsg.getExpiryTime() != null) {
                bytesSize += 8;
            }
            int propertiesSize = retainedMsg.getMqttProperties().length > 0 ? this.propertiesDataType.getMemory(retainedMsg.getMqttProperties()) : 0;
            return bytesSize + propertiesSize;
        }

        public void write(WriteBuffer buff, RetainedMessage retainedMsg) {
            StringDataType.INSTANCE.write(buff, retainedMsg.getTopic().toString());
            buff.put((byte)retainedMsg.qosLevel().value());
            buff.putInt(retainedMsg.getPayload().length);
            buff.put(retainedMsg.getPayload());
            byte flagsBitmask = 0;
            if (retainedMsg.getExpiryTime() != null) {
                flagsBitmask = (byte)(flagsBitmask | 1);
            }
            if (retainedMsg.getMqttProperties().length > 0) {
                flagsBitmask = (byte)(flagsBitmask | 2);
            }
            buff.put(flagsBitmask);
            if (retainedMsg.getExpiryTime() != null) {
                buff.putLong(retainedMsg.getExpiryTime().toEpochMilli());
            }
            if (retainedMsg.getMqttProperties().length > 0) {
                this.propertiesDataType.write(buff, retainedMsg.getMqttProperties());
            }
        }

        public RetainedMessage read(ByteBuffer buff) {
            Instant expiry;
            String topicStr = StringDataType.INSTANCE.read(buff);
            MqttQoS qos = MqttQoS.valueOf((int)buff.get());
            int payloadSize = buff.getInt();
            byte[] payload = new byte[payloadSize];
            buff.get(payload);
            byte flags = buff.get();
            if ((flags & 1) > 0) {
                long millis = buff.getLong();
                expiry = Instant.ofEpochMilli(millis);
            } else {
                expiry = null;
            }
            MqttProperties.MqttProperty[] mqttProperties = (flags & 2) > 0 ? this.propertiesDataType.read(buff) : new MqttProperties.MqttProperty[]{};
            if ((flags & 1) > 0) {
                return new RetainedMessage(new Topic(topicStr), qos, payload, mqttProperties, expiry);
            }
            return new RetainedMessage(new Topic(topicStr), qos, payload, mqttProperties);
        }

        public RetainedMessage[] createStorage(int size) {
            return new RetainedMessage[size];
        }
    }
}

