/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.List;
import java.util.Objects;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpGroup
extends Op1 {
    private VarExprList groupVars;
    private List<ExprAggregator> aggregators;

    public static OpGroup create(Op subOp, VarExprList groupVars, List<ExprAggregator> aggregators) {
        return new OpGroup(subOp, groupVars, aggregators);
    }

    public OpGroup(Op subOp, VarExprList groupVars, List<ExprAggregator> aggregators) {
        super(subOp);
        this.groupVars = groupVars;
        this.aggregators = aggregators;
    }

    @Override
    public String getName() {
        return "group";
    }

    public VarExprList getGroupVars() {
        return this.groupVars;
    }

    public List<ExprAggregator> getAggregators() {
        return this.aggregators;
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        return new OpGroup(subOp, this.groupVars, this.aggregators);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public int hashCode() {
        int x = this.getSubOp().hashCode();
        if (this.groupVars != null) {
            x ^= this.groupVars.hashCode();
        }
        if (this.aggregators != null) {
            x ^= this.aggregators.hashCode();
        }
        return x;
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpGroup)) {
            return false;
        }
        OpGroup opGroup = (OpGroup)other;
        if (!Objects.equals(this.groupVars, opGroup.groupVars)) {
            return false;
        }
        if (!Objects.equals(this.aggregators, opGroup.aggregators)) {
            return false;
        }
        return this.getSubOp().equalTo(opGroup.getSubOp(), labelMap);
    }
}

