/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Context;

public class FN_Matches
implements Function {
    E_Regex regex = null;
    ExprList myArgs = null;

    @Override
    public void build(String uri, ExprList args, Context context2) {
        if (args.size() != 3 && args.size() != 2) {
            throw new ExprEvalException("matches: Wrong number of arguments: Wanted 2 or 3, got " + args.size());
        }
        this.myArgs = args;
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        if (this.myArgs != args) {
            throw new ARQInternalErrorException("matches: Arguments have changed since checking");
        }
        Expr expr = args.get(0);
        E_Regex regexEval = this.regex;
        if (regexEval == null) {
            Expr e1 = args.get(1);
            Expr e2 = null;
            if (args.size() == 3) {
                e2 = args.get(2);
            }
            String pattern = e1.eval(binding, env).getString();
            String flags = e2 == null ? null : e2.eval(binding, env).getString();
            regexEval = new E_Regex(expr, pattern, flags);
            if (e1 instanceof NodeValue && (e2 == null || e2 instanceof NodeValue)) {
                this.regex = regexEval;
            }
        }
        NodeValue nv = regexEval.eval(binding, env);
        return nv;
    }
}

