/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.transaction.txn.StateMgrBase;
import org.apache.jena.dboe.transaction.txn.TransactionException;

public class StateMgrData
extends StateMgrBase {
    private final long[] data;

    protected StateMgrData(BufferChannel storage, long ... initialData) {
        super(storage, StateMgrData.numBytes(initialData));
        this.data = StateMgrData.copy(initialData);
        super.init();
    }

    @Override
    protected void init() {
        throw new TransactionException("Don't call init()");
    }

    private static long[] copy(long[] data) {
        return Arrays.copyOf(data, data.length);
    }

    private static int numBytes(long[] data) {
        return data.length * 8;
    }

    protected long[] getData() {
        return StateMgrData.copy(this.data);
    }

    protected void setData(long ... newData) {
        if (newData.length != this.data.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = newData[i];
        }
        this.setDirtyFlag();
    }

    protected long get(int i) {
        return this.data[i];
    }

    protected void set(int i, long v) {
        this.data[i] = v;
        super.setDirtyFlag();
    }

    @Override
    protected ByteBuffer serialize(ByteBuffer bytes) {
        for (int i = 0; i < this.data.length; ++i) {
            bytes.putLong(this.data[i]);
        }
        return bytes;
    }

    @Override
    protected void deserialize(ByteBuffer bytes) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = bytes.getLong();
        }
        super.clearDirtyFlag();
    }

    @Override
    protected void writeStateEvent() {
    }

    @Override
    protected void readStateEvent() {
    }
}

