/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.deb;

import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.Packager;
import org.apache.netbeans.nbpackage.Template;
import org.apache.netbeans.nbpackage.deb.DebTask;

public class DebPackager
implements Packager {
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle(DebPackager.class.getPackageName() + ".Messages");
    static final Option<Path> ICON_PATH = Option.ofPath("package.deb.icon", MESSAGES.getString("option.icon.help"));
    static final Option<Path> SVG_ICON_PATH = Option.ofPath("package.deb.svg-icon", MESSAGES.getString("option.svg.help"));
    static final Option<String> DESKTOP_FILENAME = Option.ofString("package.deb.desktop-filename", MESSAGES.getString("option.desktopfilename.help"));
    static final Option<String> DESKTOP_WMCLASS = Option.ofString("package.deb.wmclass", MESSAGES.getString("option.wmclass.default"), MESSAGES.getString("option.wmclass.help"));
    static final Option<String> DESKTOP_CATEGORY = Option.ofString("package.deb.category", MESSAGES.getString("option.category.default"), MESSAGES.getString("option.category.help"));
    static final Option<String> DEB_MAINTAINER = Option.ofString("package.deb.maintainer", "", MESSAGES.getString("option.maintainer.help"));
    static final Option<Path> CONTROL_TEMPLATE_PATH = Option.ofPath("package.deb.control-template", MESSAGES.getString("option.control_template.help"));
    static final Template CONTROL_TEMPLATE = Template.of(CONTROL_TEMPLATE_PATH, "deb.control.template", () -> DebPackager.class.getResourceAsStream("deb.control.template"));
    static final Option<Path> DESKTOP_TEMPLATE_PATH = Option.ofPath("package.deb.desktop-template", MESSAGES.getString("option.desktop_template.help"));
    static final Template DESKTOP_TEMPLATE = Template.of(DESKTOP_TEMPLATE_PATH, "deb.desktop.template", () -> DebPackager.class.getResourceAsStream("deb.desktop.template"));
    static final Option<Path> LAUNCHER_TEMPLATE_PATH = Option.ofPath("package.deb.launcher-template", MESSAGES.getString("option.launcher_template.help"));
    static final Template LAUNCHER_TEMPLATE = Template.of(LAUNCHER_TEMPLATE_PATH, "deb.launcher.template", () -> DebPackager.class.getResourceAsStream("deb.launcher.template"));
    private static final List<Option<?>> DEB_OPTIONS = List.of(ICON_PATH, SVG_ICON_PATH, DESKTOP_FILENAME, DESKTOP_WMCLASS, DESKTOP_CATEGORY, DEB_MAINTAINER, CONTROL_TEMPLATE_PATH, DESKTOP_TEMPLATE_PATH, LAUNCHER_TEMPLATE_PATH);
    private static final List<Template> DEB_TEMPLATES = List.of(CONTROL_TEMPLATE, DESKTOP_TEMPLATE, LAUNCHER_TEMPLATE);

    @Override
    public Packager.Task createTask(ExecutionContext context) {
        return new DebTask(context);
    }

    @Override
    public String name() {
        return "linux-deb";
    }

    @Override
    public Stream<Option<?>> options() {
        return DEB_OPTIONS.stream();
    }

    @Override
    public Stream<Template> templates() {
        return DEB_TEMPLATES.stream();
    }
}

