/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.utils;

import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MethodUtils {
    public static List<Method> findSwaggerMethods(Class<?> cls) {
        Method[] methods = cls.getMethods();
        ArrayList<Method> result = new ArrayList<Method>(methods.length);
        for (Method m : methods) {
            if (MethodUtils.isSkipMethod(cls, m)) continue;
            result.add(m);
        }
        result.sort(Comparator.comparing(MethodUtils::findSwaggerMethodName));
        return result;
    }

    public static Map<String, Method> findSwaggerMethodsMapOfOperationId(Class<?> cls) {
        List<Method> methods = MethodUtils.findSwaggerMethods(cls);
        HashMap<String, Method> result = new HashMap<String, Method>();
        methods.forEach(item -> result.put(MethodUtils.findSwaggerMethodName(item), (Method)item));
        return result;
    }

    public static boolean isSkipMethod(Class<?> cls, Method method) {
        if (method.isDefault()) {
            return true;
        }
        if (method.getDeclaringClass() == Object.class) {
            return true;
        }
        if (method.getDeclaringClass().isInterface() && !cls.isInterface()) {
            return true;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return true;
        }
        if (method.isBridge()) {
            return true;
        }
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation != null && apiOperation.hidden()) {
            return apiOperation.hidden();
        }
        return false;
    }

    public static String findSwaggerMethodName(Method method) {
        ApiOperation apiOperationAnnotation = method.getAnnotation(ApiOperation.class);
        if (apiOperationAnnotation == null || StringUtils.isEmpty((CharSequence)apiOperationAnnotation.nickname())) {
            return method.getName();
        }
        return apiOperationAnnotation.nickname();
    }
}

