/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.metadata.simple.SimpleIdentifiedObject;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.pending.geoapi.filter.AvailableFunction;
import org.apache.sis.pending.jdk.Record;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.Names;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.util.LocalName;
import org.opengis.util.TypeName;

final class FunctionDescription
extends Record
implements AvailableFunction,
Serializable {
    private static final long serialVersionUID = -264656649425360058L;
    private static final String NAMESPACE = "SQLMM";
    private final LocalName name;
    private final List<ParameterDescriptor<?>> arguments;
    private final TypeName result;

    FunctionDescription(SQLMM function, Geometries<?> library) {
        this.name = Names.createLocalName((CharSequence)NAMESPACE, null, (CharSequence)function.name());
        Argument[] args = new Argument[function.maxParamCount];
        for (int i = 0; i < args.length; ++i) {
            GeometryType gt;
            switch (i) {
                case 0: {
                    gt = function.geometryType1;
                    break;
                }
                case 1: {
                    gt = function.geometryType2;
                    break;
                }
                default: {
                    gt = null;
                }
            }
            TypeName type = gt != null ? gt.getTypeName(library) : null;
            args[i] = new Argument("arg" + (i + 1), type, Argument.getValueClass(type), true);
        }
        this.arguments = List.of(args);
        this.result = function.getGeometryType().map(t -> t.getTypeName(library)).orElseGet(() -> Names.createTypeName(function.getReturnType(library)));
    }

    @Override
    public LocalName getName() {
        return this.name;
    }

    public List<ParameterDescriptor<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public TypeName getReturnType() {
        return this.result;
    }

    private static void addType(StringBuilder sb, TypeName type) {
        if (type != null) {
            sb.append(" : ").append(type);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FunctionDescription) {
            FunctionDescription other = (FunctionDescription)obj;
            return this.name.equals((Object)other.name) && this.result.equals((Object)other.result) && this.arguments.equals(other.arguments);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + this.arguments.hashCode() + this.result.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40).append(this.name).append('(');
        boolean isMore = false;
        for (ParameterDescriptor<?> arg : this.getArguments()) {
            if (isMore) {
                sb.append(", ");
            }
            TypeName type = null;
            if (arg instanceof DefaultParameterDescriptor) {
                type = ((DefaultParameterDescriptor)arg).getValueType();
            }
            FunctionDescription.addType(sb.append(arg.getName().getCode()), type);
            isMore = true;
        }
        FunctionDescription.addType(sb.append(')'), this.getReturnType());
        return sb.toString();
    }

    private static final class Argument<T>
    extends SimpleIdentifiedObject
    implements ParameterDescriptor<T> {
        private static final long serialVersionUID = 1607271450895713628L;
        private final Class<T> valueClass;
        private final TypeName type;
        private final boolean mandatory;

        Argument(String name, TypeName type, Class<T> valueClass, boolean mandatory) {
            this.name = new NamedIdentifier(null, FunctionDescription.NAMESPACE, (CharSequence)name, null, null);
            this.type = type;
            this.valueClass = valueClass;
            this.mandatory = mandatory;
        }

        static Class<?> getValueClass(TypeName type) {
            Type t;
            if (type instanceof DefaultTypeName && (t = (Type)((DefaultTypeName)type).toJavaType().orElse(null)) instanceof Class) {
                return (Class)t;
            }
            return Object.class;
        }

        public Class<T> getValueClass() {
            return this.valueClass;
        }

        public ParameterValue<T> createValue() {
            return new DefaultParameterValue((ParameterDescriptor)this);
        }

        public int getMinimumOccurs() {
            return this.mandatory ? 1 : 0;
        }

        public int getMaximumOccurs() {
            return 1;
        }

        public Set<T> getValidValues() {
            return null;
        }

        public Comparable<T> getMinimumValue() {
            return null;
        }

        public Comparable<T> getMaximumValue() {
            return null;
        }

        public T getDefaultValue() {
            return null;
        }

        public Unit<?> getUnit() {
            return null;
        }

        public boolean equals(Object obj, ComparisonMode mode) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Argument) {
                Argument other = (Argument)((Object)obj);
                return Utilities.deepEquals((Object)this.name, (Object)other.name, (ComparisonMode)mode) && Utilities.deepEquals((Object)this.type, (Object)other.type, (ComparisonMode)mode);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.type.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(20);
            FunctionDescription.addType(sb.append(this.name.getCode()), this.type);
            return sb.toString();
        }
    }
}

