/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import org.apache.sis.storage.gdal.FeatureIterator;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.OGR;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

abstract class FieldAccessor<V> {
    static final int NUM_ADDITIONAL_FIELDS = 1;
    private static final int NUM_DATE_COMPONENTS = 7;
    private String name;
    protected final int index;

    protected FieldAccessor(String name, int index) {
        this.name = name;
        this.index = index;
    }

    final void rename(Map<String, Integer> names, Integer value) {
        String base = this.name;
        int counter = 0;
        do {
            this.name = base + " #" + ++counter;
        } while (names.putIfAbsent(this.name, value) != null);
    }

    public final String name() {
        return this.name;
    }

    int bufferSize() {
        return 0;
    }

    Class<?> getElementClass() {
        return null;
    }

    abstract Class<V> getJavaClass();

    abstract V getValue(FeatureIterator var1, OGR var2, MemorySegment var3) throws Throwable;

    final boolean hasValue(OGR ogr, MemorySegment feature) throws Throwable {
        return ogr.isFieldNull.invokeExact(feature, this.index) == 0;
    }

    static FieldAccessor<?> create(OGR ogr, MemorySegment layer, int index) throws Throwable {
        MemorySegment definition = ogr.getFieldDefinition.invokeExact(layer, index);
        String name = GDAL.toString(ogr.getFieldName.invokeExact(definition));
        int type = ogr.getFieldType.invokeExact(definition);
        switch (type) {
            case 5: 
            case 7: {
                return new StringList(name, index);
            }
            case 0: {
                return new Integer32(name, index);
            }
            case 12: {
                return new Integer64(name, index);
            }
            case 2: {
                return new Real(name, index);
            }
            case 9: {
                return new Date(name, index);
            }
            case 10: {
                return new Time(name, index);
            }
            case 11: {
                return new DateTime(name, index);
            }
            case 1: {
                return new IntegerList(name, index);
            }
            case 13: {
                return new LongList(name, index);
            }
            case 3: {
                return new RealList(name, index);
            }
            case 8: {
                return new Binary(name, index);
            }
        }
        return new Text(name, index);
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"name", this.name, "index", this.index});
    }

    private static final class StringList
    extends FieldAccessor<List<String>> {
        static final int TYPE = 5;

        StringList(String name, int index) {
            super(name, index);
        }

        @Override
        Class<List<String>> getJavaClass() {
            return List.class;
        }

        @Override
        Class<?> getElementClass() {
            return String.class;
        }

        @Override
        int bufferSize() {
            return 4;
        }

        @Override
        List<String> getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            MemorySegment p = ogr.getFieldAsStringList.invokeExact(feature, this.index);
            return GDAL.fromNullTerminatedStrings(p);
        }
    }

    private static final class Integer32
    extends FieldAccessor<Integer> {
        static final int TYPE = 0;

        Integer32(String name, int index) {
            super(name, index);
        }

        @Override
        Class<Integer> getJavaClass() {
            return Integer.class;
        }

        @Override
        Integer getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            if (this.hasValue(ogr, feature)) {
                return ogr.getFieldAsInteger.invokeExact(feature, this.index);
            }
            return null;
        }
    }

    private static final class Integer64
    extends FieldAccessor<Long> {
        static final int TYPE = 12;

        Integer64(String name, int index) {
            super(name, index);
        }

        @Override
        Class<Long> getJavaClass() {
            return Long.class;
        }

        @Override
        Long getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            if (this.hasValue(ogr, feature)) {
                return ogr.getFieldAsLong.invokeExact(feature, this.index);
            }
            return null;
        }
    }

    private static final class Real
    extends FieldAccessor<Double> {
        static final int TYPE = 2;

        Real(String name, int index) {
            super(name, index);
        }

        @Override
        Class<Double> getJavaClass() {
            return Double.class;
        }

        @Override
        Double getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            if (this.hasValue(ogr, feature)) {
                return ogr.getFieldAsDouble.invokeExact(feature, this.index);
            }
            return null;
        }
    }

    private static final class Date
    extends FieldAccessor<LocalDate> {
        static final int TYPE = 9;

        Date(String name, int index) {
            super(name, index);
        }

        @Override
        Class<LocalDate> getJavaClass() {
            return LocalDate.class;
        }

        @Override
        int bufferSize() {
            return 28;
        }

        @Override
        LocalDate getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            return source.hasDate(ogr, feature, this.index) ? source.date() : null;
        }
    }

    private static final class Time
    extends FieldAccessor<Temporal> {
        static final int TYPE = 10;

        Time(String name, int index) {
            super(name, index);
        }

        @Override
        Class<Temporal> getJavaClass() {
            return Temporal.class;
        }

        @Override
        int bufferSize() {
            return 28;
        }

        @Override
        Temporal getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            if (source.hasDate(ogr, feature, this.index)) {
                LocalTime time = source.time();
                ZoneOffset zone = source.timezone();
                return zone != null ? time.atOffset(zone) : time;
            }
            return null;
        }
    }

    private static final class DateTime
    extends FieldAccessor<Temporal> {
        static final int TYPE = 11;

        DateTime(String name, int index) {
            super(name, index);
        }

        @Override
        Class<Temporal> getJavaClass() {
            return Temporal.class;
        }

        @Override
        int bufferSize() {
            return 28;
        }

        @Override
        Temporal getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            if (source.hasDate(ogr, feature, this.index)) {
                LocalDateTime date = LocalDateTime.of(source.date(), source.time());
                ZoneOffset zone = source.timezone();
                return zone != null ? date.atOffset(zone) : date;
            }
            return null;
        }
    }

    private static final class IntegerList
    extends FieldAccessor<int[]> {
        static final int TYPE = 1;

        IntegerList(String name, int index) {
            super(name, index);
        }

        @Override
        Class<int[]> getJavaClass() {
            return int[].class;
        }

        @Override
        int bufferSize() {
            return 4;
        }

        @Override
        int[] getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            MemorySegment buffer = source.buffer();
            MemorySegment p = ogr.getFieldAsIntegerList.invokeExact(feature, this.index, buffer);
            int n = buffer.get(ValueLayout.JAVA_INT, 0L);
            if (n > 0) {
                return p.reinterpret(n * 4).toArray(ValueLayout.JAVA_INT);
            }
            return null;
        }
    }

    private static final class LongList
    extends FieldAccessor<long[]> {
        static final int TYPE = 13;

        LongList(String name, int index) {
            super(name, index);
        }

        @Override
        Class<long[]> getJavaClass() {
            return long[].class;
        }

        @Override
        int bufferSize() {
            return 4;
        }

        @Override
        long[] getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            MemorySegment buffer = source.buffer();
            MemorySegment p = ogr.getFieldAsLongList.invokeExact(feature, this.index, buffer);
            int n = buffer.get(ValueLayout.JAVA_INT, 0L);
            if (n > 0) {
                return p.reinterpret(n * 8).toArray(ValueLayout.JAVA_LONG);
            }
            return null;
        }
    }

    private static final class RealList
    extends FieldAccessor<double[]> {
        static final int TYPE = 3;

        RealList(String name, int index) {
            super(name, index);
        }

        @Override
        Class<double[]> getJavaClass() {
            return double[].class;
        }

        @Override
        int bufferSize() {
            return 4;
        }

        @Override
        double[] getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            MemorySegment buffer = source.buffer();
            MemorySegment p = ogr.getFieldAsDoubleList.invokeExact(feature, this.index, buffer);
            int n = buffer.get(ValueLayout.JAVA_INT, 0L);
            if (n > 0) {
                return p.reinterpret(n * 8).toArray(ValueLayout.JAVA_DOUBLE);
            }
            return null;
        }
    }

    private static final class Binary
    extends FieldAccessor<ByteBuffer> {
        static final int TYPE = 8;

        Binary(String name, int index) {
            super(name, index);
        }

        @Override
        Class<ByteBuffer> getJavaClass() {
            return ByteBuffer.class;
        }

        @Override
        int bufferSize() {
            return 4;
        }

        @Override
        ByteBuffer getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            MemorySegment buffer = source.buffer();
            MemorySegment p = ogr.getFieldAsBinary.invokeExact(feature, this.index, buffer);
            int n = buffer.get(ValueLayout.JAVA_INT, 0L);
            if (n > 0) {
                return ByteBuffer.wrap(p.reinterpret(n).toArray(ValueLayout.JAVA_BYTE));
            }
            return null;
        }
    }

    private static final class Text
    extends FieldAccessor<String> {
        Text(String name, int index) {
            super(name, index);
        }

        @Override
        Class<String> getJavaClass() {
            return String.class;
        }

        @Override
        String getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            if (this.hasValue(ogr, feature)) {
                return GDAL.toString(ogr.getFieldAsString.invokeExact(feature, this.index));
            }
            return null;
        }
    }

    static final class Geometry<G, V>
    extends FieldAccessor<V> {
        private final Class<V> javaClass;
        final CoordinateReferenceSystem crs;

        Geometry(String name, int index, Class<V> javaClass, CoordinateReferenceSystem crs) {
            super(name, index);
            this.javaClass = javaClass;
            this.crs = crs;
        }

        @Override
        Class<V> getJavaClass() {
            return this.javaClass;
        }

        @Override
        int bufferSize() {
            return 1024;
        }

        @Override
        V getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            MemorySegment handle = ogr.getFeatureGeometry.invokeExact(feature);
            return GDAL.isNull(handle) ? null : (V)this.javaClass.cast(source.geometry(ogr, handle));
        }
    }

    static final class Identifier
    extends FieldAccessor<Long> {
        static final Identifier INSTANCE = new Identifier();

        private Identifier() {
            super("sis:identifier", -1);
        }

        @Override
        Class<Long> getJavaClass() {
            return Long.class;
        }

        @Override
        Long getValue(FeatureIterator source, OGR ogr, MemorySegment feature) throws Throwable {
            long id = ogr.getFeatureId.invokeExact(feature);
            return id >= 0L ? Long.valueOf(id) : null;
        }
    }
}

