/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.cxf.jaxrs.testbean;

import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;

@Path("/echoservice/")
public class EchoService {
    @Context
    private HttpHeaders headers;

    @POST
    @Path("/echo/")
    public Response echo(String string) {
        Cookie fooCookie = headers.getCookies().get("foo");
        if (fooCookie != null && "bar".equals(fooCookie.getValue())) {
            return Response.ok("Old " + string).build();
        }
        return Response.ok("New " + string).cookie(
                new NewCookie.Builder("foo")
                        .value("bar")
                        .path("/")
                        .version(1)
                        .maxAge(-1)
                        .secure(false)
                        .build())
                .build();
    }
}
