/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfigurationXMLReader;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TestHierarchicalConfigurationXMLReader {
    private static final String TEST_FILE = ConfigurationAssert.getTestFile("testHierarchicalXMLConfiguration.xml").getAbsolutePath();
    private HierarchicalConfigurationXMLReader<ImmutableNode> parser;

    @BeforeEach
    public void setUp() throws Exception {
        XMLConfiguration config = new XMLConfiguration();
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load(TEST_FILE);
        this.parser = new HierarchicalConfigurationXMLReader((HierarchicalConfiguration)config);
    }

    @Test
    void testParse() throws Exception {
        SAXSource source = new SAXSource((XMLReader)this.parser, new InputSource());
        DOMResult result = new DOMResult();
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(source, result);
        Element root = ((Document)result.getNode()).getDocumentElement();
        JXPathContext ctx = JXPathContext.newContext((Object)root);
        Assertions.assertEquals((Object)"database", (Object)root.getNodeName());
        Assertions.assertEquals((int)1, (int)ctx.selectNodes("/*").size());
        Assertions.assertEquals((int)2, (int)ctx.selectNodes("/tables/table").size());
        Assertions.assertEquals((Object)"users", (Object)ctx.getValue("/tables/table[1]/name"));
        Assertions.assertEquals((int)5, (int)ctx.selectNodes("/tables/table[1]/fields/field").size());
        Assertions.assertEquals((Object)"system", (Object)ctx.getValue("/tables/table[1]/@tableType"));
    }
}

