/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.junit.jupiter.api.condition.AbstractRepeatableAnnotationCondition;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.platform.commons.util.Preconditions;

class DisabledIfSystemPropertyCondition
extends AbstractRepeatableAnnotationCondition<DisabledIfSystemProperty> {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled("No @DisabledIfSystemProperty conditions resulting in 'disabled' execution encountered");

    DisabledIfSystemPropertyCondition() {
        super(DisabledIfSystemProperty.class);
    }

    @Override
    protected ConditionEvaluationResult getNoDisabledConditionsEncounteredResult() {
        return ENABLED;
    }

    @Override
    protected ConditionEvaluationResult evaluate(DisabledIfSystemProperty annotation) {
        String name = annotation.named().trim();
        String regex = annotation.matches();
        Preconditions.notBlank(name, () -> "The 'named' attribute must not be blank in " + annotation);
        Preconditions.notBlank(regex, () -> "The 'matches' attribute must not be blank in " + annotation);
        String actual = System.getProperty(name);
        if (actual == null) {
            return ConditionEvaluationResult.enabled(String.format("System property [%s] does not exist", name));
        }
        if (actual.matches(regex)) {
            return ConditionEvaluationResult.disabled(String.format("System property [%s] with value [%s] matches regular expression [%s]", name, actual, regex), annotation.disabledReason());
        }
        return ConditionEvaluationResult.enabled(String.format("System property [%s] with value [%s] does not match regular expression [%s]", name, actual, regex));
    }
}

