/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereUtils;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.VoidServletConfig;
import org.eclipse.jetty.server.Request;
import org.springframework.util.ClassUtils;

public class AtmosphereWebSocketJettyDestination
extends JettyHTTPDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(AtmosphereWebSocketJettyDestination.class);
    private AtmosphereFramework framework;
    private final Map<String, String> initParams = new HashMap<String, String>();

    public AtmosphereWebSocketJettyDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, serverEngineFactory == null ? null : new URL(AtmosphereWebSocketJettyDestination.getNonWSAddress(ei)), serverEngineFactory);
        this.framework = new AtmosphereFramework(false, true);
        this.framework.setUseNativeImplementation(false);
        AtmosphereWebSocketJettyDestination.addInitParameter(this.framework, this.initParams, "org.atmosphere.useNative", "true");
        AtmosphereWebSocketJettyDestination.addInitParameter(this.framework, this.initParams, "org.atmosphere.cpr.sessionSupport", "true");
        AtmosphereWebSocketJettyDestination.addInitParameter(this.framework, this.initParams, "org.atmosphere.useWebSocket", "true");
        AtmosphereWebSocketJettyDestination.addInitParameter(this.framework, this.initParams, "org.atmosphere.websocket.WebSocketProtocol.executeAsync", "true");
        AtmosphereWebSocketJettyDestination.addInitParameter(this.framework, this.initParams, "org.atmosphere.websocket.suppressJSR356", "true");
        AtmosphereUtils.addInterceptors(this.framework, bus);
        this.framework.addAtmosphereHandler("/", (AtmosphereHandler)new DestinationHandler());
    }

    protected void activate() {
        super.activate();
        if (this.handler.getServletContext().getAttribute("org.eclipse.jetty.util.DecoratedObjectFactory") == null) {
            try {
                Class dcc = ClassUtils.forName((String)"org.eclipse.jetty.util.DecoratedObjectFactory", (ClassLoader)this.getClass().getClassLoader());
                this.handler.getServletContext().setAttribute("org.eclipse.jetty.util.DecoratedObjectFactory", dcc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | LinkageError | NoSuchMethodException | SecurityException | InvocationTargetException dcc) {
                // empty catch block
            }
        }
        VoidServletConfig config = new VoidServletConfig(this.initParams){

            public ServletContext getServletContext() {
                return AtmosphereWebSocketJettyDestination.this.handler.getServletContext();
            }
        };
        try {
            this.framework.init((ServletConfig)config);
        }
        catch (ServletException e) {
            throw new Fault(new Message("Could not initialize WebSocket Framework", LOG, new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private static void addInitParameter(AtmosphereFramework fw, Map<String, String> initParams, String name, String value) {
        fw.addInitParameter(name, value);
        initParams.put(name, value);
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    private static String getNonWSAddress(EndpointInfo endpointInfo) {
        Object address = endpointInfo.getAddress();
        if (((String)address).startsWith("ws")) {
            address = "http" + ((String)address).substring(2);
        }
        return address;
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        return AtmosphereWebSocketJettyDestination.getNonWSAddress(endpointInfo);
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.getAddress(this.endpointInfo)).getPath();
    }

    protected JettyHTTPHandler createJettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        return new AtmosphereJettyWebSocketHandler(jhd, cmExact);
    }

    public void shutdown() {
        try {
            this.framework.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            super.shutdown();
        }
    }

    AtmosphereFramework getAtmosphereFramework() {
        return this.framework;
    }

    private final class DestinationHandler
    extends AbstractReflectorAtmosphereHandler {
        private DestinationHandler() {
        }

        public void onRequest(AtmosphereResource resource) throws IOException {
            LOG.fine("onRequest");
            try {
                AtmosphereWebSocketJettyDestination.this.invokeInternal(null, resource.getRequest().getServletContext(), (HttpServletRequest)resource.getRequest(), (HttpServletResponse)resource.getResponse());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to invoke service", e);
            }
        }
    }

    private class AtmosphereJettyWebSocketHandler
    extends JettyHTTPHandler {
        AtmosphereJettyWebSocketHandler(JettyHTTPDestination jhd, boolean cmExact) {
            super(jhd, cmExact);
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (AtmosphereUtils.useAtmosphere(request)) {
                try {
                    AtmosphereWebSocketJettyDestination.this.framework.doCometSupport(AtmosphereRequestImpl.wrap((HttpServletRequest)request), AtmosphereResponseImpl.wrap((HttpServletResponse)response));
                    baseRequest.setHandled(true);
                }
                catch (ServletException e) {
                    throw new IOException(e);
                }
                return;
            }
            super.handle(target, baseRequest, request, response);
        }
    }
}

