/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsn.jms;

import jakarta.jms.Topic;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.cxf.wsn.jms.InvalidTopicException;
import org.oasis_open.docs.wsn.b_2.TopicExpressionType;

public class JmsTopicExpressionConverter {
    public static final String SIMPLE_DIALECT = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple";

    public TopicExpressionType toTopicExpression(Topic topic) {
        return this.toTopicExpression(topic.toString());
    }

    public TopicExpressionType toTopicExpression(ActiveMQTopic topic) {
        return this.toTopicExpression(topic.getTopicName());
    }

    public TopicExpressionType toTopicExpression(String name) {
        TopicExpressionType answer = new TopicExpressionType();
        answer.getContent().add(name);
        answer.setDialect(SIMPLE_DIALECT);
        return answer;
    }

    public ActiveMQTopic toActiveMQTopic(TopicExpressionType topic) throws InvalidTopicException {
        String dialect = topic.getDialect();
        if (dialect == null || SIMPLE_DIALECT.equals(dialect)) {
            Iterator iter = topic.getContent().iterator();
            while (iter.hasNext()) {
                ActiveMQTopic answer = this.createActiveMQTopicFromContent(iter.next());
                if (answer == null) continue;
                return answer;
            }
            throw new InvalidTopicException("No topic name available topic: " + topic);
        }
        throw new InvalidTopicException("Topic dialect: " + dialect + " not supported");
    }

    protected ActiveMQTopic createActiveMQTopicFromContent(Object contentItem) {
        if (contentItem instanceof String) {
            return new ActiveMQTopic(((String)contentItem).trim());
        }
        if (contentItem instanceof QName) {
            return this.createActiveMQTopicFromQName((QName)contentItem);
        }
        return null;
    }

    protected ActiveMQTopic createActiveMQTopicFromQName(QName qName) {
        return new ActiveMQTopic(qName.toString());
    }
}

