/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AodSketchCrossLanguageTest {
    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTestingOneValue() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            ArrayOfDoublesUpdatableSketch sk = new ArrayOfDoublesUpdatableSketchBuilder().build();
            for (int i = 0; i < n; ++i) {
                sk.update((long)i, new double[]{i});
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("aod_1_n" + n + "_java.sk"), new OpenOption[0]).write(sk.compact().toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTestingThreeValues() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            ArrayOfDoublesUpdatableSketch sk = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(3).build();
            for (int i = 0; i < n; ++i) {
                sk.update((long)i, new double[]{i, i, i});
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("aod_3_n" + n + "_java.sk"), new OpenOption[0]).write(sk.compact().toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTestingNonEmptyNoEntries() throws IOException {
        ArrayOfDoublesUpdatableSketch sk = new ArrayOfDoublesUpdatableSketchBuilder().setSamplingProbability(0.01f).build();
        sk.update(1L, new double[]{1.0});
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertEquals((int)sk.getRetainedEntries(), (int)0);
        Files.newOutputStream(TestUtil.javaPath.resolve("aod_1_non_empty_no_entries_java.sk"), new OpenOption[0]).write(sk.compact().toByteArray());
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppOneValue() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("aod_1_n" + n + "_cpp.sk"));
            ArrayOfDoublesSketch sketch = ArrayOfDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.03));
            Assert.assertEquals((int)sketch.getNumValues(), (int)1);
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            while (it.next()) {
                Assert.assertTrue((it.getKey() < sketch.getThetaLong() ? 1 : 0) != 0);
            }
        }
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppThreeValues() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("aod_3_n" + n + "_cpp.sk"));
            ArrayOfDoublesSketch sketch = ArrayOfDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.03));
            Assert.assertEquals((int)sketch.getNumValues(), (int)3);
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            while (it.next()) {
                Assert.assertTrue((it.getKey() < sketch.getThetaLong() ? 1 : 0) != 0);
                Assert.assertEquals((double)it.getValues()[0], (double)it.getValues()[1]);
                Assert.assertEquals((double)it.getValues()[0], (double)it.getValues()[2]);
            }
        }
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppOneValueNonEmptyNoEntries() throws IOException {
        byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("aod_1_non_empty_no_entries_cpp.sk"));
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketch.wrap((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
    }
}

