/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.util.Objects;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.AbstractCoupons;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.BaseHllSketch;
import org.apache.datasketches.hll.CouponHashSet;
import org.apache.datasketches.hll.CouponList;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectCouponHashSet;
import org.apache.datasketches.hll.DirectCouponList;
import org.apache.datasketches.hll.DirectHll4Array;
import org.apache.datasketches.hll.DirectHll6Array;
import org.apache.datasketches.hll.DirectHll8Array;
import org.apache.datasketches.hll.Hll4Array;
import org.apache.datasketches.hll.Hll6Array;
import org.apache.datasketches.hll.Hll8Array;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUnion;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

public class HllSketch
extends BaseHllSketch {
    public static final int DEFAULT_LG_K = 12;
    public static final TgtHllType DEFAULT_HLL_TYPE = TgtHllType.HLL_4;
    HllSketchImpl hllSketchImpl = null;

    public HllSketch() {
        this(12, DEFAULT_HLL_TYPE);
    }

    public HllSketch(int lgConfigK) {
        this(lgConfigK, DEFAULT_HLL_TYPE);
    }

    public HllSketch(int lgConfigK, TgtHllType tgtHllType) {
        this.hllSketchImpl = new CouponList(HllUtil.checkLgK(lgConfigK), tgtHllType, CurMode.LIST);
    }

    public HllSketch(int lgConfigK, TgtHllType tgtHllType, MemorySegment dstSeg) {
        Objects.requireNonNull(dstSeg, "Destination MemorySegment must not be null");
        long minBytes = HllSketch.getMaxUpdatableSerializationBytes(lgConfigK, tgtHllType);
        long capBytes = dstSeg.byteSize();
        HllUtil.checkSegSize(minBytes, capBytes);
        Util.clear(dstSeg, 0L, minBytes);
        this.hllSketchImpl = DirectCouponList.newInstance(lgConfigK, tgtHllType, dstSeg);
    }

    HllSketch(HllSketch that) {
        this.hllSketchImpl = that.hllSketchImpl.copy();
    }

    HllSketch(HllSketchImpl that) {
        this.hllSketchImpl = that;
    }

    public static final HllSketch heapify(byte[] byteArray) {
        return HllSketch.heapify(MemorySegment.ofArray(byteArray));
    }

    public static final HllSketch heapify(MemorySegment srcSeg) {
        return HllSketch.heapify(srcSeg, true);
    }

    static final HllSketch heapify(MemorySegment srcSeg, boolean checkRebuild) {
        HllSketch heapSketch;
        Objects.requireNonNull(srcSeg, "Source MemorySegment must not be null");
        Util.checkBounds(0L, 8L, srcSeg.byteSize());
        CurMode curMode = HllUtil.checkPreamble(srcSeg);
        if (curMode == CurMode.HLL) {
            TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(srcSeg);
            if (tgtHllType == TgtHllType.HLL_4) {
                heapSketch = new HllSketch(Hll4Array.heapify(srcSeg));
            } else if (tgtHllType == TgtHllType.HLL_6) {
                heapSketch = new HllSketch(Hll6Array.heapify(srcSeg));
            } else {
                heapSketch = new HllSketch(Hll8Array.heapify(srcSeg));
                if (checkRebuild) {
                    HllUnion.checkRebuildCurMinNumKxQ(heapSketch);
                }
            }
        } else {
            heapSketch = curMode == CurMode.LIST ? new HllSketch(CouponList.heapifyList(srcSeg)) : new HllSketch(CouponHashSet.heapifySet(srcSeg));
        }
        return heapSketch;
    }

    public static final HllSketch writableWrap(MemorySegment srcWseg) {
        if (srcWseg.isReadOnly()) {
            return HllSketch.wrap(srcWseg);
        }
        return HllSketch.writableWrap(srcWseg, true);
    }

    static final HllSketch writableWrap(MemorySegment srcWseg, boolean checkRebuild) {
        HllSketch directSketch;
        Objects.requireNonNull(srcWseg, "Source MemorySegment must not be null");
        Util.checkBounds(0L, 8L, srcWseg.byteSize());
        if (PreambleUtil.extractCompactFlag(srcWseg)) {
            throw new SketchesArgumentException("Cannot perform a writableWrap of a sketch image that is in compact form. Compact sketches are by definition immutable.");
        }
        int lgConfigK = PreambleUtil.extractLgK(srcWseg);
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(srcWseg);
        long minBytes = HllSketch.getMaxUpdatableSerializationBytes(lgConfigK, tgtHllType);
        long capBytes = srcWseg.byteSize();
        HllUtil.checkSegSize(minBytes, capBytes);
        CurMode curMode = HllUtil.checkPreamble(srcWseg);
        if (curMode == CurMode.HLL) {
            if (tgtHllType == TgtHllType.HLL_4) {
                directSketch = new HllSketch(new DirectHll4Array(lgConfigK, srcWseg));
            } else if (tgtHllType == TgtHllType.HLL_6) {
                directSketch = new HllSketch(new DirectHll6Array(lgConfigK, srcWseg));
            } else {
                directSketch = new HllSketch(new DirectHll8Array(lgConfigK, srcWseg));
                if (checkRebuild) {
                    HllUnion.checkRebuildCurMinNumKxQ(directSketch);
                }
            }
        } else {
            directSketch = curMode == CurMode.LIST ? new HllSketch(new DirectCouponList(lgConfigK, tgtHllType, curMode, srcWseg)) : new HllSketch(new DirectCouponHashSet(lgConfigK, tgtHllType, srcWseg));
        }
        return directSketch;
    }

    public static final HllSketch wrap(MemorySegment srcSeg) {
        HllSketch directSketch;
        Objects.requireNonNull(srcSeg, "Source MemorySegment must not be null");
        Util.checkBounds(0L, 8L, srcSeg.byteSize());
        int lgConfigK = PreambleUtil.extractLgK(srcSeg);
        TgtHllType tgtHllType = PreambleUtil.extractTgtHllType(srcSeg);
        CurMode curMode = HllUtil.checkPreamble(srcSeg);
        if (curMode == CurMode.HLL) {
            if (tgtHllType == TgtHllType.HLL_4) {
                directSketch = new HllSketch(new DirectHll4Array(lgConfigK, srcSeg, true));
            } else if (tgtHllType == TgtHllType.HLL_6) {
                directSketch = new HllSketch(new DirectHll6Array(lgConfigK, srcSeg, true));
            } else {
                directSketch = new HllSketch(new DirectHll8Array(lgConfigK, srcSeg, true));
                HllUnion.checkRebuildCurMinNumKxQ(directSketch);
            }
        } else {
            directSketch = curMode == CurMode.LIST ? new HllSketch(new DirectCouponList(lgConfigK, tgtHllType, curMode, srcSeg, true)) : new HllSketch(new DirectCouponHashSet(lgConfigK, tgtHllType, srcSeg, true));
        }
        return directSketch;
    }

    public HllSketch copy() {
        return new HllSketch(this);
    }

    public HllSketch copyAs(TgtHllType tgtHllType) {
        return new HllSketch(this.hllSketchImpl.copyAs(tgtHllType));
    }

    @Override
    public double getCompositeEstimate() {
        return this.hllSketchImpl.getCompositeEstimate();
    }

    @Override
    public double getEstimate() {
        return this.hllSketchImpl.getEstimate();
    }

    double getHipEstimate() {
        return this.hllSketchImpl.getHipEstimate();
    }

    @Override
    public int getLgConfigK() {
        return this.hllSketchImpl.getLgConfigK();
    }

    @Override
    public int getCompactSerializationBytes() {
        return this.hllSketchImpl.getCompactSerializationBytes();
    }

    @Override
    public double getLowerBound(int numStdDev) {
        return this.hllSketchImpl.getLowerBound(numStdDev);
    }

    public static final int getMaxUpdatableSerializationBytes(int lgConfigK, TgtHllType tgtHllType) {
        int arrBytes;
        if (tgtHllType == TgtHllType.HLL_4) {
            int auxBytes = 4 << HllUtil.LG_AUX_ARR_INTS[lgConfigK];
            arrBytes = AbstractHllArray.hll4ArrBytes(lgConfigK) + auxBytes;
        } else {
            arrBytes = tgtHllType == TgtHllType.HLL_6 ? AbstractHllArray.hll6ArrBytes(lgConfigK) : AbstractHllArray.hll8ArrBytes(lgConfigK);
        }
        return PreambleUtil.HLL_BYTE_ARR_START + arrBytes;
    }

    MemorySegment getMemorySegment() {
        return this.hllSketchImpl.getMemorySegment();
    }

    @Override
    public TgtHllType getTgtHllType() {
        return this.hllSketchImpl.getTgtHllType();
    }

    @Override
    public int getUpdatableSerializationBytes() {
        return this.hllSketchImpl.getUpdatableSerializationBytes();
    }

    @Override
    public double getUpperBound(int numStdDev) {
        return this.hllSketchImpl.getUpperBound(numStdDev);
    }

    @Override
    public boolean isCompact() {
        return this.hllSketchImpl.isCompact();
    }

    @Override
    public boolean isEmpty() {
        return this.hllSketchImpl.isEmpty();
    }

    @Override
    public boolean hasMemorySegment() {
        return this.hllSketchImpl.hasMemorySegment();
    }

    @Override
    public boolean isOffHeap() {
        return this.hllSketchImpl.isOffHeap();
    }

    @Override
    boolean isOutOfOrder() {
        return this.hllSketchImpl.isOutOfOrder();
    }

    @Override
    public boolean isSameResource(MemorySegment seg) {
        return this.hllSketchImpl.isSameResource(seg);
    }

    void mergeTo(HllSketch that) {
        this.hllSketchImpl.mergeTo(that);
    }

    HllSketch putOutOfOrderFlag(boolean oooFlag) {
        this.hllSketchImpl.putOutOfOrder(oooFlag);
        return this;
    }

    @Override
    public void reset() {
        this.hllSketchImpl = this.hllSketchImpl.reset();
    }

    @Override
    public byte[] toCompactByteArray() {
        return this.hllSketchImpl.toCompactByteArray();
    }

    @Override
    public byte[] toUpdatableByteArray() {
        return this.hllSketchImpl.toUpdatableByteArray();
    }

    @Override
    public String toString(boolean summary, boolean detail, boolean auxDetail, boolean all) {
        StringBuilder sb;
        block12: {
            PairIterator auxItr;
            AbstractHllArray absHll;
            sb = new StringBuilder();
            if (summary) {
                sb.append("### HLL SKETCH SUMMARY: ").append(Util.LS);
                sb.append("  Log Config K   : ").append(this.getLgConfigK()).append(Util.LS);
                sb.append("  Hll Target     : ").append((Object)this.getTgtHllType()).append(Util.LS);
                sb.append("  Current Mode   : ").append((Object)this.getCurMode()).append(Util.LS);
                sb.append("  MemorySegment  : ").append(this.hasMemorySegment()).append(Util.LS);
                sb.append("  LB             : ").append(this.getLowerBound(1)).append(Util.LS);
                sb.append("  Estimate       : ").append(this.getEstimate()).append(Util.LS);
                sb.append("  UB             : ").append(this.getUpperBound(1)).append(Util.LS);
                sb.append("  OutOfOrder Flag: ").append(this.isOutOfOrder()).append(Util.LS);
                if (this.getCurMode() == CurMode.HLL) {
                    absHll = (AbstractHllArray)this.hllSketchImpl;
                    sb.append("  CurMin         : ").append(absHll.getCurMin()).append(Util.LS);
                    sb.append("  NumAtCurMin    : ").append(absHll.getNumAtCurMin()).append(Util.LS);
                    sb.append("  HipAccum       : ").append(absHll.getHipAccum()).append(Util.LS);
                    sb.append("  KxQ0           : ").append(absHll.getKxQ0()).append(Util.LS);
                    sb.append("  KxQ1           : ").append(absHll.getKxQ1()).append(Util.LS);
                    sb.append("  Rebuild KxQ Flg: ").append(absHll.isRebuildCurMinNumKxQFlag()).append(Util.LS);
                } else {
                    sb.append("  Coupon Count   : ").append(((AbstractCoupons)this.hllSketchImpl).getCouponCount()).append(Util.LS);
                }
            }
            if (detail) {
                sb.append("### HLL SKETCH DATA DETAIL: ").append(Util.LS);
                PairIterator pitr = this.iterator();
                sb.append(pitr.getHeader()).append(Util.LS);
                if (all) {
                    while (pitr.nextAll()) {
                        sb.append(pitr.getString()).append(Util.LS);
                    }
                } else {
                    while (pitr.nextValid()) {
                        sb.append(pitr.getString()).append(Util.LS);
                    }
                }
            }
            if (!auxDetail || this.getCurMode() != CurMode.HLL || this.getTgtHllType() != TgtHllType.HLL_4 || (auxItr = (absHll = (AbstractHllArray)this.hllSketchImpl).getAuxIterator()) == null) break block12;
            sb.append("### HLL SKETCH AUX DETAIL: ").append(Util.LS);
            sb.append(auxItr.getHeader()).append(Util.LS);
            if (all) {
                while (auxItr.nextAll()) {
                    sb.append(auxItr.getString()).append(Util.LS);
                }
            } else {
                while (auxItr.nextValid()) {
                    sb.append(auxItr.getString()).append(Util.LS);
                }
            }
        }
        return sb.toString();
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.toString(byteArr);
    }

    public static String toString(MemorySegment seg) {
        return PreambleUtil.toString(seg);
    }

    PairIterator iterator() {
        return this.hllSketchImpl.iterator();
    }

    @Override
    CurMode getCurMode() {
        return this.hllSketchImpl.getCurMode();
    }

    @Override
    void couponUpdate(int coupon) {
        if (coupon >>> 26 == 0) {
            return;
        }
        this.hllSketchImpl = this.hllSketchImpl.couponUpdate(coupon);
    }
}

