/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.resource.ResourceDescriptor;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.resource.SerializableResource;
import org.apache.flink.api.java.tuple.Tuple3;

public class Agent {
    private final Map<String, Tuple3<Class<? extends Event>[], Method, Map<String, Object>>> actions;
    private final Map<ResourceType, Map<String, Object>> resources = new HashMap<ResourceType, Map<String, Object>>();

    public Agent() {
        for (ResourceType type : ResourceType.values()) {
            this.resources.put(type, new HashMap());
        }
        this.actions = new HashMap<String, Tuple3<Class<? extends Event>[], Method, Map<String, Object>>>();
    }

    public Map<String, Tuple3<Class<? extends Event>[], Method, Map<String, Object>>> getActions() {
        return this.actions;
    }

    public Map<ResourceType, Map<String, Object>> getResources() {
        return this.resources;
    }

    public Agent addAction(Class<? extends Event>[] events, Method method, @Nullable Map<String, Object> config) {
        String name = method.getName();
        if (this.actions.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Action %s already defined.", name));
        }
        this.actions.put(name, (Tuple3<Class<? extends Event>[], Method, Map<String, Object>>)new Tuple3(events, (Object)method, config));
        return this;
    }

    public Agent addAction(Class<? extends Event>[] events, Method method) {
        return this.addAction(events, method, null);
    }

    public void addResourcesIfAbsent(Map<ResourceType, Map<String, Object>> resources) {
        for (ResourceType type : resources.keySet()) {
            Map<String, Object> typedResources = resources.get((Object)type);
            typedResources.forEach(this.resources.get((Object)type)::putIfAbsent);
        }
    }

    public Agent addResource(String name, ResourceType type, Object instance) {
        if (this.resources.get((Object)type).containsKey(name)) {
            throw new IllegalArgumentException(String.format("%s %s already defined.", new Object[]{type, name}));
        }
        if (instance instanceof SerializableResource) {
            this.resources.get((Object)type).put(name, instance);
        } else if (instance instanceof ResourceDescriptor) {
            this.resources.get((Object)type).put(name, instance);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported resource %s", instance.getClass().getName()));
        }
        return this;
    }
}

