/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpCacheEntryFactory {
    public static final HttpCacheEntryFactory INSTANCE = new HttpCacheEntryFactory();

    private static HeaderGroup headers(Iterator<Header> it) {
        HeaderGroup headerGroup = new HeaderGroup();
        while (it.hasNext()) {
            headerGroup.addHeader(it.next());
        }
        return headerGroup;
    }

    HeaderGroup mergeHeaders(HttpCacheEntry entry, HttpResponse response) {
        HeaderGroup headerGroup = new HeaderGroup();
        Iterator<Header> it = entry.headerIterator();
        while (it.hasNext()) {
            Header entryHeader = it.next();
            String headerName = entryHeader.getName();
            if (response.containsHeader(headerName)) continue;
            headerGroup.addHeader(entryHeader);
        }
        Set responseHopByHop = MessageSupport.hopByHopConnectionSpecific((MessageHeaders)response);
        Iterator it2 = response.headerIterator();
        while (it2.hasNext()) {
            Header responseHeader = (Header)it2.next();
            String headerName = responseHeader.getName();
            if (responseHopByHop.contains(headerName.toLowerCase(Locale.ROOT))) continue;
            headerGroup.addHeader(responseHeader);
        }
        return headerGroup;
    }

    static HeaderGroup filterHopByHopHeaders(HttpMessage message) {
        Set hopByHop = MessageSupport.hopByHopConnectionSpecific((MessageHeaders)message);
        HeaderGroup headerGroup = new HeaderGroup();
        Iterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            if (hopByHop.contains(header.getName())) continue;
            headerGroup.addHeader(header);
        }
        return headerGroup;
    }

    static void ensureDate(HeaderGroup headers, Instant instant) {
        if (!headers.containsHeader("Date")) {
            headers.addHeader((Header)new BasicHeader("Date", (Object)DateUtils.formatStandardDate((Instant)instant)));
        }
    }

    public HttpCacheEntry createRoot(HttpCacheEntry latestVariant, Collection<String> variants) {
        Args.notNull((Object)latestVariant, (String)"Request");
        Args.notNull(variants, (String)"Variants");
        return new HttpCacheEntry(latestVariant.getRequestInstant(), latestVariant.getResponseInstant(), latestVariant.getRequestMethod(), latestVariant.getRequestURI(), HttpCacheEntryFactory.headers(latestVariant.requestHeaderIterator()), latestVariant.getStatus(), HttpCacheEntryFactory.headers(latestVariant.headerIterator()), null, variants);
    }

    public HttpCacheEntry create(Instant requestInstant, Instant responseInstant, HttpHost host, HttpRequest request, HttpResponse response, Resource resource) {
        Args.notNull((Object)requestInstant, (String)"Request instant");
        Args.notNull((Object)responseInstant, (String)"Response instant");
        Args.notNull((Object)host, (String)"Host");
        Args.notNull((Object)request, (String)"Request");
        Args.notNull((Object)response, (String)"Origin response");
        String s = CacheKeyGenerator.getRequestUri(host, request);
        URI uri = CacheKeyGenerator.normalize(s);
        HeaderGroup requestHeaders = HttpCacheEntryFactory.filterHopByHopHeaders((HttpMessage)request);
        requestHeaders.removeHeaders("Authorization");
        HeaderGroup responseHeaders = HttpCacheEntryFactory.filterHopByHopHeaders((HttpMessage)response);
        HttpCacheEntryFactory.ensureDate(responseHeaders, responseInstant);
        return new HttpCacheEntry(requestInstant, responseInstant, request.getMethod(), uri.toASCIIString(), requestHeaders, response.getCode(), responseHeaders, resource, null);
    }

    public HttpCacheEntry createUpdated(Instant requestInstant, Instant responseInstant, HttpHost host, HttpRequest request, HttpResponse response, HttpCacheEntry entry) {
        Args.notNull((Object)requestInstant, (String)"Request instant");
        Args.notNull((Object)responseInstant, (String)"Response instant");
        Args.notNull((Object)response, (String)"Origin response");
        Args.check((response.getCode() == 304 ? 1 : 0) != 0, (String)"Response must have 304 status code");
        Args.notNull((Object)entry, (String)"Cache entry");
        if (HttpCacheEntry.isNewer(entry, (MessageHeaders)response)) {
            return entry;
        }
        String s = CacheKeyGenerator.getRequestUri(host, request);
        URI uri = CacheKeyGenerator.normalize(s);
        HeaderGroup requestHeaders = HttpCacheEntryFactory.filterHopByHopHeaders((HttpMessage)request);
        requestHeaders.removeHeaders("Authorization");
        HeaderGroup mergedHeaders = this.mergeHeaders(entry, response);
        return new HttpCacheEntry(requestInstant, responseInstant, request.getMethod(), uri.toASCIIString(), requestHeaders, entry.getStatus(), mergedHeaders, entry.getResource(), null);
    }

    public HttpCacheEntry copy(HttpCacheEntry entry) {
        if (entry == null) {
            return null;
        }
        return new HttpCacheEntry(entry.getRequestInstant(), entry.getResponseInstant(), entry.getRequestMethod(), entry.getRequestURI(), HttpCacheEntryFactory.headers(entry.requestHeaderIterator()), entry.getStatus(), HttpCacheEntryFactory.headers(entry.headerIterator()), entry.getResource(), (Collection<String>)(entry.hasVariants() ? new HashSet<String>(entry.getVariants()) : null));
    }
}

