/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.bootstrap.HttpRequester;
import org.apache.hc.core5.http.impl.bootstrap.RequesterBootstrap;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.util.Timeout;

public class ClassicPostExecutionExample {
    public static void main(String[] args) throws Exception {
        HttpRequester httpRequester = RequesterBootstrap.bootstrap().setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
                System.out.println(connection.getRemoteAddress() + " " + new RequestLine(request));
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
                System.out.println(connection.getRemoteAddress() + " " + new StatusLine(response));
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                if (keepAlive) {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection kept alive)");
                } else {
                    System.out.println(connection.getRemoteAddress() + " exchange completed (connection closed)");
                }
            }
        }).setSocketConfig(SocketConfig.custom().setSoTimeout(5, TimeUnit.SECONDS).build()).create();
        HttpCoreContext context = HttpCoreContext.create();
        HttpHost target = new HttpHost("httpbin.org");
        HttpEntity[] requestBodies = new HttpEntity[]{HttpEntities.create((String)"This is the first test request", (ContentType)ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)), HttpEntities.create((byte[])"This is the second test request".getBytes(StandardCharsets.UTF_8), (ContentType)ContentType.APPLICATION_OCTET_STREAM), HttpEntities.create(outStream -> outStream.write("This is the third test request (streaming)".getBytes(StandardCharsets.UTF_8)), (ContentType)ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)), HttpEntities.create((String)"This is the fourth test request (streaming with trailers)", (ContentType)ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8), (Header[])new Header[]{new BasicHeader("trailer1", (Object)"And goodbye")})};
        String requestUri = "/post";
        for (int i = 0; i < requestBodies.length; ++i) {
            ClassicHttpRequest request = ClassicRequestBuilder.get().setHttpHost(target).setPath("/post").build();
            request.setEntity(requestBodies[i]);
            try (ClassicHttpResponse response = httpRequester.execute(target, request, Timeout.ofSeconds((long)5L), (HttpContext)context);){
                System.out.println("/post->" + response.getCode());
                System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
                System.out.println("==============");
                continue;
            }
        }
    }
}

