/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.micrometer.core.instrument.Timer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.utils.IMQTTMessageSizer;
import org.apache.bifromq.mqtt.utils.MQTTMessageTrimmer;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.OversizePacketDropped;
import org.apache.bifromq.type.ClientInfo;

public class MQTTPacketFilter
extends ChannelOutboundHandlerAdapter {
    public static final String NAME = "MQTT5SizeBasedPacketFilter";
    private final ClientInfo clientInfo;
    private final IEventCollector eventCollector;
    private final ITenantMeter tenantMeter;
    private final int maxPacketSize;
    private final boolean enableTrim;
    private final IMQTTMessageSizer sizer;

    public MQTTPacketFilter(int maxPacketSize, TenantSettings settings, ClientInfo clientInfo, IEventCollector eventCollector) {
        this.eventCollector = eventCollector;
        this.tenantMeter = ITenantMeter.get((String)clientInfo.getTenantId());
        this.clientInfo = clientInfo;
        this.maxPacketSize = Math.min(maxPacketSize, settings.maxPacketSize);
        this.enableTrim = clientInfo.getMetadataOrDefault("ver", "").equals("5");
        this.sizer = this.enableTrim ? IMQTTMessageSizer.mqtt5() : IMQTTMessageSizer.mqtt3();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        assert (msg instanceof MqttMessage);
        MqttMessage mqttMessage = (MqttMessage)msg;
        IMQTTMessageSizer.MqttMessageSize messageSize = this.sizer.sizeOf(mqttMessage);
        AtomicInteger encodedBytes = new AtomicInteger(messageSize.encodedBytes());
        if (encodedBytes.get() <= this.maxPacketSize) {
            promise.addListener(this.logMetric(mqttMessage, encodedBytes.get()));
            super.write(ctx, msg, promise);
            return;
        }
        if (this.enableTrim && this.isTrimable(mqttMessage)) {
            encodedBytes.set(messageSize.encodedBytes(true, false));
            if (encodedBytes.get() <= this.maxPacketSize) {
                promise.addListener(this.logMetric(mqttMessage, encodedBytes.get()));
                super.write(ctx, (Object)MQTTMessageTrimmer.trim(mqttMessage, true, false), promise);
                return;
            }
            encodedBytes.set(messageSize.encodedBytes(false, false));
            if (encodedBytes.get() <= this.maxPacketSize) {
                promise.addListener(this.logMetric(mqttMessage, encodedBytes.get()));
                super.write(ctx, (Object)MQTTMessageTrimmer.trim(mqttMessage, true, true), promise);
                return;
            }
        }
        this.eventCollector.report((Event)((OversizePacketDropped)ThreadLocalEventPool.getLocal(OversizePacketDropped.class)).mqttPacketType(mqttMessage.fixedHeader().messageType().value()).clientInfo(this.clientInfo));
    }

    private GenericFutureListener<? extends Future<? super Void>> logMetric(MqttMessage message, int size) {
        Timer.Sample start = Timer.start();
        return future -> {
            if (future.isSuccess()) {
                if (Objects.requireNonNull(message.fixedHeader().messageType()) == MqttMessageType.PUBLISH) {
                    switch (message.fixedHeader().qosLevel()) {
                        case AT_MOST_ONCE: {
                            this.tenantMeter.recordSummary(TenantMetric.MqttQoS0EgressBytes, (double)size);
                            break;
                        }
                        case AT_LEAST_ONCE: {
                            this.tenantMeter.recordSummary(TenantMetric.MqttQoS1EgressBytes, (double)size);
                            break;
                        }
                        case EXACTLY_ONCE: {
                            this.tenantMeter.recordSummary(TenantMetric.MqttQoS2EgressBytes, (double)size);
                        }
                    }
                }
                this.tenantMeter.recordSummary(TenantMetric.MqttEgressBytes, (double)size);
                start.stop(this.tenantMeter.timer(TenantMetric.MqttChannelLatency));
            }
        };
    }

    private boolean isTrimable(MqttMessage message) {
        return switch (message.fixedHeader().messageType()) {
            case MqttMessageType.PUBLISH, MqttMessageType.CONNACK, MqttMessageType.DISCONNECT -> false;
            default -> true;
        };
    }
}

