/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.lang.ref.Cleaner;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TenantMeter
implements ITenantMeter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantMeter.class);
    private static final Cleaner CLEANER = Cleaner.create();
    private final State state;
    private final Tags tags;
    private final Cleaner.Cleanable cleanable;

    public TenantMeter(String tenantId) {
        this.tags = Tags.of((String)"tenantId", (String)tenantId);
        this.state = new State(this.tags);
        this.cleanable = CLEANER.register(this, this.state);
    }

    @Override
    public void recordCount(TenantMetric metric) {
        this.recordCount(metric, 1.0);
    }

    @Override
    public void recordCount(TenantMetric metric, double inc) {
        assert (metric.meterType == Meter.Type.COUNTER);
        ((Counter)this.state.meters.get((Object)metric)).increment(inc);
    }

    @Override
    public Timer timer(TenantMetric metric) {
        assert (metric.meterType == Meter.Type.TIMER);
        return (Timer)this.state.meters.get((Object)metric);
    }

    @Override
    public void recordSummary(TenantMetric metric, double value) {
        assert (metric.meterType == Meter.Type.DISTRIBUTION_SUMMARY);
        ((DistributionSummary)this.state.meters.get((Object)metric)).record(value);
    }

    public void destroy() {
        this.cleanable.clean();
    }

    private static class State
    implements Runnable {
        final Map<TenantMetric, Meter> meters = new HashMap<TenantMetric, Meter>();

        State(Tags tags) {
            block6: for (TenantMetric metric : TenantMetric.values()) {
                switch (metric.meterType) {
                    case COUNTER: {
                        if (metric.isFunction) continue block6;
                        this.meters.put(metric, (Meter)Metrics.counter((String)metric.metricName, (Iterable)tags));
                        continue block6;
                    }
                    case TIMER: {
                        this.meters.put(metric, (Meter)Metrics.timer((String)metric.metricName, (Iterable)tags));
                        continue block6;
                    }
                    case DISTRIBUTION_SUMMARY: {
                        this.meters.put(metric, (Meter)Metrics.summary((String)metric.metricName, (Iterable)tags));
                        continue block6;
                    }
                    case GAUGE: {
                        continue block6;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported traffic meter type");
                    }
                }
            }
        }

        @Override
        public void run() {
            this.meters.values().forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
            this.meters.clear();
        }
    }
}

