/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.hash.Funnel;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.base.util.RendezvousHash;
import org.apache.bifromq.basecluster.agent.proto.AgentEndpoint;
import org.apache.bifromq.basecluster.memberlist.CRDTUtil;
import org.apache.bifromq.basecluster.memberlist.IHostAddressResolver;
import org.apache.bifromq.basecluster.memberlist.IHostMemberList;
import org.apache.bifromq.basecluster.memberlist.agent.Agent;
import org.apache.bifromq.basecluster.memberlist.agent.AgentAddressProvider;
import org.apache.bifromq.basecluster.memberlist.agent.AgentMessenger;
import org.apache.bifromq.basecluster.memberlist.agent.IAgent;
import org.apache.bifromq.basecluster.membership.proto.Doubt;
import org.apache.bifromq.basecluster.membership.proto.Fail;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.membership.proto.HostMember;
import org.apache.bifromq.basecluster.membership.proto.Join;
import org.apache.bifromq.basecluster.membership.proto.Quit;
import org.apache.bifromq.basecluster.messenger.IMessenger;
import org.apache.bifromq.basecluster.messenger.MessageEnvelope;
import org.apache.bifromq.basecluster.proto.ClusterMessage;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.store.ICRDTStore;
import org.apache.bifromq.basecrdt.store.ReplicaIdGenerator;
import org.apache.bifromq.basehlc.HLC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostMemberList
implements IHostMemberList {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HostMemberList.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.JOINED);
    private final IMessenger messenger;
    private final Scheduler scheduler;
    private final ICRDTStore store;
    private final IHostAddressResolver addressResolver;
    private final BehaviorSubject<Map<HostEndpoint, HostMember>> membershipSubject = BehaviorSubject.createDefault(new ConcurrentHashMap());
    private final PublishSubject<Long> refuteSubject = PublishSubject.create();
    private final Map<String, Agent> agentMap = new ConcurrentHashMap<String, Agent>();
    private final IORMap hostListCRDT;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final MetricManager metricManager;
    private final String[] tags;
    private volatile HostMember local;

    public HostMemberList(String bindAddr, int port, IMessenger messenger, Scheduler scheduler, ICRDTStore store, IHostAddressResolver addressResolver, String ... tags) {
        this.messenger = messenger;
        this.scheduler = scheduler;
        this.store = store;
        this.addressResolver = addressResolver;
        this.tags = tags;
        Replica replicaId = ReplicaIdGenerator.generate((String)CRDTUtil.AGENT_HOST_MAP_URI, (ByteString)ByteString.copyFromUtf8((String)store.id()));
        this.local = HostMember.newBuilder().setEndpoint(HostEndpoint.newBuilder().setId(replicaId.getId()).setAddress(bindAddr).setPort(port).setPid(ProcessHandle.current().pid()).build()).setIncarnation(0).build();
        this.hostListCRDT = (IORMap)store.host(replicaId, this.local.getEndpoint().toByteString());
        this.join(this.local);
        this.disposables.add(this.hostListCRDT.inflation().observeOn(scheduler).subscribe(this::sync));
        this.disposables.add(messenger.receive().map(m -> ((MessageEnvelope)m.value()).message).observeOn(scheduler).subscribe(this::handleMessage));
        this.metricManager = new MetricManager();
    }

    @Override
    public HostMember local() {
        return this.local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean join(HostMember member) {
        if (this.isZombie(member.getEndpoint())) {
            return false;
        }
        HostMemberList hostMemberList = this;
        synchronized (hostMemberList) {
            boolean joined = this.addMember(member);
            if (joined) {
                Optional<HostMember> memberInCRDT;
                log.debug("Member[{}] joins the cluster: local={}", (Object)member, (Object)this.local);
                if (member == this.local && ((memberInCRDT = CRDTUtil.getHostMember(this.hostListCRDT, member.getEndpoint())).isEmpty() || memberInCRDT.get().getIncarnation() < member.getIncarnation())) {
                    this.hostListCRDT.execute((ICRDTOperation)ORMapOperation.update((ByteString[])new ByteString[]{member.getEndpoint().toByteString()}).with(MVRegOperation.write((ByteString)member.toByteString())));
                }
                this.store.join(this.hostListCRDT.id(), this.currentMembers().keySet().stream().map(AbstractMessageLite::toByteString).collect(Collectors.toSet()));
            }
            return joined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop(HostEndpoint memberEndpoint, int incarnation, boolean fromQuit) {
        HostMemberList hostMemberList = this;
        synchronized (hostMemberList) {
            boolean removed = this.removeMember(memberEndpoint, incarnation);
            Optional<HostMember> memberInCRDT = CRDTUtil.getHostMember(this.hostListCRDT, memberEndpoint);
            if (!fromQuit && memberInCRDT.isPresent() && this.shouldReportFailure(memberInCRDT.get().getEndpoint())) {
                this.hostListCRDT.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{memberEndpoint.toByteString()}).of(CausalCRDTType.mvreg));
            }
            if (removed) {
                this.store.join(this.hostListCRDT.id(), this.currentMembers().keySet().stream().map(AbstractMessageLite::toByteString).collect(Collectors.toSet()));
            }
        }
    }

    private boolean shouldReportFailure(HostEndpoint failedMemberEndpoint) {
        RendezvousHash hash = RendezvousHash.builder().keyFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.getId().asReadOnlyByteBuffer())).nodeFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.getId().asReadOnlyByteBuffer())).nodes(this.currentMembers().keySet()).build();
        HostEndpoint reporter = (HostEndpoint)hash.get((Object)failedMemberEndpoint);
        return reporter.getId().equals((Object)this.local.getEndpoint().getId());
    }

    @Override
    public boolean isZombie(HostEndpoint endpoint) {
        return !endpoint.getId().equals((Object)this.local.getEndpoint().getId()) && endpoint.getAddress().equals(this.local.getEndpoint().getAddress()) && endpoint.getPort() == this.local.getEndpoint().getPort();
    }

    private InetSocketAddress getMemberAddress(HostEndpoint endpoint) {
        Map aliveHostList = (Map)this.membershipSubject.getValue();
        return !aliveHostList.containsKey(endpoint) ? null : this.addressResolver.resolve(endpoint);
    }

    @Override
    public CompletableFuture<Void> stop() {
        if (this.state.compareAndSet(State.JOINED, State.QUITTING)) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])this.agentMap.values().stream().map(Agent::quit).toArray(CompletableFuture[]::new)).exceptionally(e -> null)).thenCompose(v -> {
                HostMemberList hostMemberList = this;
                synchronized (hostMemberList) {
                    this.disposables.dispose();
                    this.removeMember(this.local.getEndpoint(), this.local.getIncarnation());
                    return this.hostListCRDT.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{this.local.getEndpoint().toByteString()}).of(CausalCRDTType.mvreg)).exceptionally(e -> null);
                }
            })).thenCompose(v1 -> {
                ClusterMessage quit = ClusterMessage.newBuilder().setQuit(Quit.newBuilder().setEndpoint(this.local.getEndpoint()).setIncarnation(this.local.getIncarnation()).build()).build();
                return this.messenger.spread(quit).handle((v, e) -> null);
            })).thenCompose(v -> this.store.stopHosting(this.hostListCRDT.id()))).whenComplete((v, e) -> {
                this.membershipSubject.onComplete();
                this.refuteSubject.onComplete();
                this.metricManager.close();
                this.state.set(State.QUITED);
            });
        }
        if (this.state.get() == State.QUITTING) {
            return CompletableFuture.failedFuture(new IllegalStateException("quit has started"));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Observable<Map<HostEndpoint, Integer>> members() {
        return this.membershipSubject.map(hostMap -> Maps.transformValues((Map)hostMap, HostMember::getIncarnation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renew(int atLeastIncarnation) {
        HostMemberList hostMemberList = this;
        synchronized (hostMemberList) {
            this.local = this.local.toBuilder().setIncarnation(Math.max(this.local.getIncarnation(), atLeastIncarnation) + 1).build();
            this.join(this.local);
            this.agentMap.values().forEach(Agent::refreshRegistration);
            this.refuteSubject.onNext((Object)HLC.INST.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAgent host(String agentId) {
        this.checkState();
        HostMemberList hostMemberList = this;
        synchronized (hostMemberList) {
            if (!this.local.containsAgent(agentId)) {
                AgentEndpoint agentEndpoint = AgentEndpoint.newBuilder().setEndpoint(this.local.getEndpoint()).setIncarnation(HLC.INST.get()).build();
                this.agentMap.put(agentId, new Agent(agentId, agentEndpoint, new AgentMessenger(agentId, this::getMemberAddress, this.messenger), this.scheduler, this.store, new AgentAddressProvider(agentId, (Observable<Map<HostEndpoint, HostMember>>)this.membershipSubject), this.tags));
                this.local = this.local.toBuilder().setIncarnation(this.local.getIncarnation() + 1).putAgent(agentId, agentEndpoint.getIncarnation()).build();
                this.join(this.local);
            }
            return this.agentMap.get(agentId);
        }
    }

    @Override
    public CompletableFuture<Void> stopHosting(String agentId) {
        this.checkState();
        Agent agent = this.agentMap.remove(agentId);
        if (agent != null) {
            return agent.quit().whenComplete((v, e) -> {
                HostMemberList hostMemberList = this;
                synchronized (hostMemberList) {
                    this.local = this.local.toBuilder().setIncarnation(this.local.getIncarnation() + 1).clearAgent().putAllAgent(Maps.transformValues(this.agentMap, a -> a.local().getIncarnation())).build();
                }
                this.join(this.local);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Observable<Map<HostEndpoint, Set<String>>> landscape() {
        return this.membershipSubject.map(m -> Maps.transformValues((Map)m, v -> v.getAgentMap().keySet()));
    }

    @Override
    public Observable<Long> refuteSignal() {
        return this.refuteSubject;
    }

    private Map<HostEndpoint, HostMember> currentMembers() {
        return (Map)this.membershipSubject.getValue();
    }

    private boolean addMember(HostMember member) {
        boolean joined;
        HashMap members = Maps.newHashMap((Map)((Map)this.membershipSubject.getValue()));
        boolean bl = joined = members.compute(member.getEndpoint(), (k, v) -> {
            if (v == null) {
                return member;
            }
            return member.getIncarnation() > v.getIncarnation() ? member : v;
        }) == member;
        if (joined) {
            this.membershipSubject.onNext((Object)members);
        }
        return joined;
    }

    private boolean removeMember(HostEndpoint endpoint, int incarnation) {
        HashMap members = Maps.newHashMap((Map)((Map)this.membershipSubject.getValue()));
        AtomicBoolean removed = new AtomicBoolean();
        members.computeIfPresent(endpoint, (k, v) -> {
            if (v.getIncarnation() <= incarnation) {
                removed.set(true);
                return null;
            }
            return v;
        });
        if (removed.get()) {
            this.membershipSubject.onNext((Object)members);
        }
        return removed.get();
    }

    private void handleMessage(ClusterMessage message) {
        if (this.state.get() != State.JOINED) {
            return;
        }
        switch (message.getClusterMessageTypeCase()) {
            case JOIN: {
                this.handleJoin(message.getJoin());
                break;
            }
            case QUIT: {
                this.handleQuit(message.getQuit());
                break;
            }
            case FAIL: {
                this.handleFail(message.getFail());
                break;
            }
            case DOUBT: {
                this.handleDoubt(message.getDoubt());
                break;
            }
        }
    }

    private void handleJoin(Join join) {
        HostMember joinMember = join.getMember();
        if (!join.hasExpectedHost() && !this.isZombie(joinMember.getEndpoint()) || join.getExpectedHost().equals(this.local.getEndpoint())) {
            boolean newMember = this.join(joinMember);
            if (join.hasExpectedHost()) {
                if (!newMember) {
                    this.renew(this.local.getIncarnation());
                }
                this.messenger.send(ClusterMessage.newBuilder().setJoin(Join.newBuilder().setMember(this.local).build()).build(), this.getMemberAddress(joinMember.getEndpoint()), true);
            } else if (newMember) {
                this.messenger.send(ClusterMessage.newBuilder().setJoin(Join.newBuilder().setMember(this.local).build()).build(), this.getMemberAddress(joinMember.getEndpoint()), true);
            }
        } else {
            this.clearZombie(join.getExpectedHost());
        }
    }

    private void handleFail(Fail fail) {
        HostEndpoint failedEndpoint = fail.getEndpoint();
        if (failedEndpoint.equals(this.local.getEndpoint())) {
            if (fail.getIncarnation() >= this.local.getIncarnation()) {
                log.debug("Renew[{}] to refute failure report", (Object)this.local);
                this.renew(fail.getIncarnation());
                this.messenger.spread(ClusterMessage.newBuilder().setJoin(Join.newBuilder().setMember(this.local).build()).build());
            }
        } else if (this.isZombie(failedEndpoint)) {
            this.clearZombie(failedEndpoint);
        } else {
            this.drop(failedEndpoint, fail.getIncarnation(), false);
        }
    }

    private void handleQuit(Quit quit) {
        HostEndpoint quitEndpoint = quit.getEndpoint();
        log.debug("Member[{}] quits the cluster", (Object)quitEndpoint);
        if (!quitEndpoint.equals(this.local.getEndpoint()) && !this.isZombie(quitEndpoint)) {
            this.drop(quitEndpoint, quit.getIncarnation(), true);
        }
    }

    private void handleDoubt(Doubt doubt) {
        if (doubt.getEndpoint().equals(this.local.getEndpoint()) && doubt.getIncarnation() >= this.local.getIncarnation()) {
            log.debug("Member[{}] refutes the death suspicion from reporter[{}]", (Object)this.local, (Object)doubt.getReporter());
            this.renew(doubt.getIncarnation());
            this.messenger.spread(ClusterMessage.newBuilder().setJoin(Join.newBuilder().setMember(this.local).build()).build());
        }
    }

    private void clearZombie(HostEndpoint zombieEndpoint) {
        this.drop(zombieEndpoint, Integer.MAX_VALUE, false);
        this.messenger.spread(ClusterMessage.newBuilder().setQuit(Quit.newBuilder().setEndpoint(zombieEndpoint).setIncarnation(Integer.MAX_VALUE).build()).build());
    }

    private void sync(long ts) {
        if (this.state.get() != State.JOINED) {
            return;
        }
        Optional<HostMember> localMemberInCRDT = CRDTUtil.getHostMember(this.hostListCRDT, this.local.getEndpoint());
        if (localMemberInCRDT.isEmpty() || localMemberInCRDT.get().getIncarnation() > this.local.getIncarnation()) {
            this.renew(localMemberInCRDT.orElse(this.local).getIncarnation());
        }
        Iterator<HostMember> itr = CRDTUtil.iterate(this.hostListCRDT);
        while (itr.hasNext()) {
            HostMember observed = itr.next();
            if (observed.getEndpoint().equals(this.local.getEndpoint())) continue;
            if (this.isZombie(observed.getEndpoint())) {
                this.clearZombie(observed.getEndpoint());
                continue;
            }
            this.join(observed);
        }
    }

    private void checkState() {
        Preconditions.checkState((this.state.get() == State.JOINED ? 1 : 0) != 0);
    }

    private static enum State {
        JOINED,
        QUITTING,
        QUITED;

    }

    private class MetricManager {
        private final Set<Meter> meters = new HashSet<Meter>();

        MetricManager() {
            Tags metricTags = Tags.of((String[])HostMemberList.this.tags);
            this.meters.add((Meter)Gauge.builder((String)"basecluster.crdt.agentcluster.count", HostMemberList.this.agentMap, Map::size).tags((Iterable)metricTags).register((MeterRegistry)Metrics.globalRegistry));
            this.meters.add((Meter)Gauge.builder((String)"basecluster.crdt.hostcluster.size", HostMemberList.this.membershipSubject, a -> ((Map)a.getValue()).size()).tags((Iterable)metricTags).register((MeterRegistry)Metrics.globalRegistry));
        }

        void close() {
            this.meters.forEach(meter -> Metrics.globalRegistry.removeByPreFilterId(meter.getId()));
        }
    }
}

