/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server;

import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.dist.RPCBluePrint;
import org.apache.bifromq.dist.server.DistServerBuilder;
import org.apache.bifromq.dist.server.DistService;
import org.apache.bifromq.dist.server.IDistServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistServer
implements IDistServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistServer.class);
    private final DistService distService;
    private final ExecutorService rpcExecutor;

    DistServer(DistServerBuilder builder) {
        this.distService = new DistService(builder.distWorkerClient, builder.settingProvider, builder.eventCollector);
        this.rpcExecutor = builder.workerThreads == 0 ? MoreExecutors.newDirectExecutorService() : ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(builder.workerThreads, builder.workerThreads, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("dist-server-executor")), (String)"dist-server-executor", (Tag[])new Tag[0]);
        builder.rpcServerBuilder.bindService(this.distService.bindService(), RPCBluePrint.INSTANCE, builder.attributes, builder.defaultGroupTags, (Executor)this.rpcExecutor);
    }

    @Override
    public void close() {
        log.info("Stop DistService");
        this.distService.stop();
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.rpcExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        log.info("DistService stopped");
    }
}

