/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.client.scheduler;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.basescheduler.BatchCallScheduler;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.IBatchCallBuilder;
import org.apache.bifromq.sessiondict.SessionRegisterKeyUtil;
import org.apache.bifromq.sessiondict.client.scheduler.BatchSessionExistCall;
import org.apache.bifromq.sessiondict.client.scheduler.IOnlineCheckScheduler;
import org.apache.bifromq.sessiondict.client.type.OnlineCheckRequest;
import org.apache.bifromq.sessiondict.client.type.OnlineCheckResult;
import org.apache.bifromq.sessiondict.rpc.proto.ExistReply;
import org.apache.bifromq.sessiondict.rpc.proto.ExistRequest;
import org.apache.bifromq.sessiondict.rpc.proto.SessionDictServiceGrpc;
import org.apache.bifromq.sysprops.props.DataPlaneMaxBurstLatencyMillis;

public class OnlineCheckScheduler
extends BatchCallScheduler<OnlineCheckRequest, OnlineCheckResult, String>
implements IOnlineCheckScheduler {
    public OnlineCheckScheduler(final IRPCClient rpcClient) {
        super((name, batcherKey) -> new IBatchCallBuilder<OnlineCheckRequest, OnlineCheckResult, String>(){
            private final IRPCClient.IRequestPipeline<ExistRequest, ExistReply> ppln;
            {
                this.ppln = rpcClient.createRequestPipeline(SessionRegisterKeyUtil.parseTenantId((String)batcherKey), null, batcherKey, Collections.emptyMap(), SessionDictServiceGrpc.getExistMethod());
            }

            public IBatchCall<OnlineCheckRequest, OnlineCheckResult, String> newBatchCall() {
                return new BatchSessionExistCall(this.ppln);
            }

            public void close() {
                this.ppln.close();
            }
        }, Duration.ofMillis((Long)DataPlaneMaxBurstLatencyMillis.INSTANCE.get()).toNanos());
    }

    protected Optional<String> find(OnlineCheckRequest call) {
        return Optional.of(SessionRegisterKeyUtil.toRegisterKey((String)call.tenantId(), (String)call.userId(), (String)call.clientId()));
    }
}

