/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zjsonpatch.internal.collections4;

import io.fabric8.zjsonpatch.internal.collections4.DefaultEquator;
import io.fabric8.zjsonpatch.internal.collections4.Equator;
import io.fabric8.zjsonpatch.internal.collections4.sequence.CommandVisitor;
import io.fabric8.zjsonpatch.internal.collections4.sequence.EditScript;
import io.fabric8.zjsonpatch.internal.collections4.sequence.SequencesComparator;
import java.util.ArrayList;
import java.util.List;

public class ListUtils {
    public static <E> List<E> longestCommonSubsequence(List<E> a, List<E> b) {
        return ListUtils.longestCommonSubsequence(a, b, DefaultEquator.defaultEquator());
    }

    public static <E> List<E> longestCommonSubsequence(List<E> a, List<E> b, Equator<? super E> equator) {
        if (a == null || b == null) {
            throw new NullPointerException("List must not be null");
        }
        if (equator == null) {
            throw new NullPointerException("Equator must not be null");
        }
        SequencesComparator<E> comparator = new SequencesComparator<E>(a, b, equator);
        EditScript<E> script = comparator.getScript();
        LcsVisitor visitor = new LcsVisitor();
        script.visit(visitor);
        return visitor.getSubSequence();
    }

    private static final class LcsVisitor<E>
    implements CommandVisitor<E> {
        private ArrayList<E> sequence = new ArrayList();

        @Override
        public void visitInsertCommand(E object) {
        }

        @Override
        public void visitDeleteCommand(E object) {
        }

        @Override
        public void visitKeepCommand(E object) {
            this.sequence.add(object);
        }

        public List<E> getSubSequence() {
            return this.sequence;
        }
    }
}

