/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.payload.evolvable.batch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.sink.client.IoTDBDataNodeCacheLeaderClientManager;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.batch.PipeTabletEventBatch;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.batch.PipeTabletEventPlainBatch;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.batch.PipeTabletEventTsFileBatch;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.metrics.impl.DoNothingHistogram;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferBatchReqBuilder
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferBatchReqBuilder.class);
    private final boolean useLeaderCache;
    private final int requestMaxDelayInMs;
    private final long requestMaxBatchSizeInBytes;
    private Histogram tabletBatchSizeHistogram = new DoNothingHistogram();
    private Histogram tsFileBatchSizeHistogram = new DoNothingHistogram();
    private Histogram tabletBatchTimeIntervalHistogram = new DoNothingHistogram();
    private Histogram tsFileBatchTimeIntervalHistogram = new DoNothingHistogram();
    private Histogram eventSizeHistogram = new DoNothingHistogram();
    private final PipeTabletEventBatch defaultBatch;
    private final Map<TEndPoint, PipeTabletEventPlainBatch> endPointToBatch = new ConcurrentHashMap<TEndPoint, PipeTabletEventPlainBatch>();

    public PipeTransferBatchReqBuilder(PipeParameters parameters) {
        boolean usingTsFileBatch = parameters.getStringOrDefault(Arrays.asList("connector.format", "sink.format"), "hybrid").equals("tsfile");
        this.useLeaderCache = !usingTsFileBatch && parameters.getBooleanOrDefault(Arrays.asList("sink.leader-cache.enable", "connector.leader-cache.enable"), true);
        Integer requestMaxDelayInMillis = parameters.getIntByKeys(new String[]{"connector.batch.max-delay-ms", "sink.batch.max-delay-ms"});
        if (Objects.isNull(requestMaxDelayInMillis)) {
            int requestMaxDelayConfig = parameters.getIntOrDefault(Arrays.asList("connector.batch.max-delay-seconds", "sink.batch.max-delay-seconds"), usingTsFileBatch ? 5000 : 20);
            this.requestMaxDelayInMs = requestMaxDelayConfig < 0 ? Integer.MAX_VALUE : requestMaxDelayConfig;
        } else {
            this.requestMaxDelayInMs = requestMaxDelayInMillis < 0 ? Integer.MAX_VALUE : requestMaxDelayInMillis;
        }
        this.requestMaxBatchSizeInBytes = parameters.getLongOrDefault(Arrays.asList("connector.batch.size-bytes", "sink.batch.size-bytes"), usingTsFileBatch ? 0x1000000L : 0x100000L);
        this.defaultBatch = usingTsFileBatch ? new PipeTabletEventTsFileBatch(this.requestMaxDelayInMs, this.requestMaxBatchSizeInBytes, this::recordTsFileMetric) : new PipeTabletEventPlainBatch(this.requestMaxDelayInMs, this.requestMaxBatchSizeInBytes, this::recordTabletMetric);
    }

    public synchronized void onEvent(TabletInsertionEvent event) throws IOException, WALPipeException {
        if (!(event instanceof EnrichedEvent)) {
            LOGGER.warn("Unsupported event {} type {} when building transfer request", (Object)event, event.getClass());
            return;
        }
        if (!this.useLeaderCache) {
            this.defaultBatch.onEvent(event);
            return;
        }
        String deviceId = null;
        if (event instanceof PipeRawTabletInsertionEvent) {
            deviceId = ((PipeRawTabletInsertionEvent)event).getDeviceId();
        } else if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            deviceId = ((PipeInsertNodeTabletInsertionEvent)event).getDeviceId();
        }
        if (Objects.isNull(deviceId)) {
            this.defaultBatch.onEvent(event);
            return;
        }
        TEndPoint endPoint = IoTDBDataNodeCacheLeaderClientManager.LEADER_CACHE_MANAGER.getLeaderEndPoint(deviceId);
        if (Objects.isNull(endPoint)) {
            this.defaultBatch.onEvent(event);
            return;
        }
        this.endPointToBatch.computeIfAbsent(endPoint, k -> new PipeTabletEventPlainBatch(this.requestMaxDelayInMs, this.requestMaxBatchSizeInBytes, this::recordTabletMetric)).onEvent(event);
    }

    public synchronized List<Pair<TEndPoint, PipeTabletEventBatch>> getAllNonEmptyAndShouldEmitBatches() {
        ArrayList<Pair<TEndPoint, PipeTabletEventBatch>> nonEmptyAndShouldEmitBatches = new ArrayList<Pair<TEndPoint, PipeTabletEventBatch>>();
        if (!this.defaultBatch.isEmpty() && this.defaultBatch.shouldEmit()) {
            nonEmptyAndShouldEmitBatches.add((Pair<TEndPoint, PipeTabletEventBatch>)new Pair(null, (Object)this.defaultBatch));
        }
        this.endPointToBatch.forEach((endPoint, batch) -> {
            if (!batch.isEmpty() && batch.shouldEmit()) {
                nonEmptyAndShouldEmitBatches.add(new Pair(endPoint, batch));
            }
        });
        return nonEmptyAndShouldEmitBatches;
    }

    public boolean isEmpty() {
        return this.defaultBatch.isEmpty() && this.endPointToBatch.values().stream().allMatch(PipeTabletEventBatch::isEmpty);
    }

    public synchronized void discardEventsOfPipe(String pipeNameToDrop, int regionId) {
        this.defaultBatch.discardEventsOfPipe(pipeNameToDrop, regionId);
        this.endPointToBatch.values().forEach(batch -> batch.discardEventsOfPipe(pipeNameToDrop, regionId));
    }

    public int size() {
        try {
            return this.defaultBatch.events.size() + this.endPointToBatch.values().stream().map(batch -> batch.events.size()).reduce(0, Integer::sum);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get the size of PipeTransferBatchReqBuilder, return 0. Exception: {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    @Override
    public synchronized void close() {
        this.defaultBatch.close();
        this.endPointToBatch.values().forEach(PipeTabletEventBatch::close);
    }

    public void recordTabletMetric(long timeInterval, long bufferSize, long eventSize) {
        this.tabletBatchTimeIntervalHistogram.update(timeInterval);
        this.tabletBatchSizeHistogram.update(bufferSize);
        this.eventSizeHistogram.update(eventSize);
    }

    public void recordTsFileMetric(long timeInterval, long bufferSize, long eventSize) {
        this.tsFileBatchTimeIntervalHistogram.update(timeInterval);
        this.tsFileBatchSizeHistogram.update(bufferSize);
        this.eventSizeHistogram.update(eventSize);
    }

    public void setTabletBatchSizeHistogram(Histogram tabletBatchSizeHistogram) {
        if (tabletBatchSizeHistogram != null) {
            this.tabletBatchSizeHistogram = tabletBatchSizeHistogram;
        }
    }

    public void setTsFileBatchSizeHistogram(Histogram tsFileBatchSizeHistogram) {
        if (tsFileBatchSizeHistogram != null) {
            this.tsFileBatchSizeHistogram = tsFileBatchSizeHistogram;
        }
    }

    public void setTabletBatchTimeIntervalHistogram(Histogram tabletBatchTimeIntervalHistogram) {
        if (tabletBatchTimeIntervalHistogram != null) {
            this.tabletBatchTimeIntervalHistogram = tabletBatchTimeIntervalHistogram;
        }
    }

    public void setTsFileBatchTimeIntervalHistogram(Histogram tsFileBatchTimeIntervalHistogram) {
        if (tsFileBatchTimeIntervalHistogram != null) {
            this.tsFileBatchTimeIntervalHistogram = tsFileBatchTimeIntervalHistogram;
        }
    }

    public void setEventSizeHistogram(Histogram eventSizeHistogram) {
        if (eventSizeHistogram != null) {
            this.eventSizeHistogram = eventSizeHistogram;
        }
    }
}

