/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.tsfile.write.record.Tablet;

public class TableSession
implements ITableSession {
    private final Session session;

    TableSession(Session session) {
        this.session = session;
    }

    public void insert(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        this.session.insertRelationalTablet(tablet);
    }

    public void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        this.session.executeNonQueryStatement(sql);
    }

    public SessionDataSet executeQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        return this.session.executeQueryStatement(sql);
    }

    public SessionDataSet executeQueryStatement(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        return this.session.executeQueryStatement(sql, timeoutInMs);
    }

    public void close() throws IoTDBConnectionException {
        this.session.close();
    }
}

