/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.rpccompress;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.List;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.tsfile.compress.ICompressor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class TabletEncoder {
    private final CompressionType compressionType;
    private final List<TSEncoding> encodingList;

    public TabletEncoder(CompressionType compressionType, List<TSEncoding> encodingList) {
        this.compressionType = compressionType;
        this.encodingList = encodingList;
    }

    public ByteBuffer encodeTime(Tablet tablet) {
        Encoder encoder = TSEncodingBuilder.getEncodingBuilder((TSEncoding)this.encodingList.get(0)).getEncoder(TSDataType.INT64);
        PublicBAOS baos = new PublicBAOS();
        for (int i = 0; i < tablet.getRowSize(); ++i) {
            encoder.encode(tablet.getTimestamp(i), (ByteArrayOutputStream)baos);
        }
        try {
            encoder.flush((ByteArrayOutputStream)baos);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ByteBuffer buffer = ByteBuffer.wrap(baos.getBuf(), 0, baos.size());
        return this.compressBuffer(buffer);
    }

    public ByteBuffer encodeValues(Tablet tablet) {
        PublicBAOS baos = new PublicBAOS();
        List schemas = tablet.getSchemas();
        int schemasSize = schemas.size();
        for (int j = 0; j < schemasSize; ++j) {
            IMeasurementSchema schema = (IMeasurementSchema)schemas.get(j);
            TSDataType dataType = schema.getType();
            TSEncoding encoding = this.encodingList.get(j + 1);
            Encoder encoder = TSEncodingBuilder.getEncodingBuilder((TSEncoding)encoding).getEncoder(dataType);
            if (encoding == TSEncoding.PLAIN) {
                if (dataType.isBinary()) {
                    this.encodePlainBinary(tablet, j, (ByteArrayOutputStream)baos);
                    continue;
                }
                if (dataType == TSDataType.INT32) {
                    this.encodePlainI32(tablet, j, (ByteArrayOutputStream)baos);
                    continue;
                }
                if (dataType == TSDataType.DATE) {
                    this.encodePlainDate(tablet, j, (ByteArrayOutputStream)baos);
                    continue;
                }
                SessionUtils.encodeValue(dataType, tablet, j, encoder, (ByteArrayOutputStream)baos);
                continue;
            }
            SessionUtils.encodeValue(dataType, tablet, j, encoder, (ByteArrayOutputStream)baos);
        }
        this.encodeBitMap(tablet, (ByteArrayOutputStream)baos);
        ByteBuffer buffer = ByteBuffer.wrap(baos.getBuf(), 0, baos.size());
        return this.compressBuffer(buffer);
    }

    private void encodePlainBinary(Tablet tablet, int j, ByteArrayOutputStream baos) {
        Binary[] binaryValues = (Binary[])tablet.getValues()[j];
        try {
            for (int index = 0; index < tablet.getRowSize(); ++index) {
                if (!tablet.isNull(index, j)) {
                    ReadWriteIOUtils.write((Binary)binaryValues[index], (OutputStream)baos);
                    continue;
                }
                ReadWriteIOUtils.write((Binary)Binary.EMPTY_VALUE, (OutputStream)baos);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void encodePlainI32(Tablet tablet, int j, ByteArrayOutputStream baos) {
        int[] intValues = (int[])tablet.getValues()[j];
        try {
            for (int index = 0; index < tablet.getRowSize(); ++index) {
                ReadWriteIOUtils.write((int)intValues[index], (OutputStream)baos);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void encodePlainDate(Tablet tablet, int j, ByteArrayOutputStream baos) {
        LocalDate[] dateValues = (LocalDate[])tablet.getValues()[j];
        try {
            for (int index = 0; index < tablet.getRowSize(); ++index) {
                if (!tablet.isNull(index, j)) {
                    ReadWriteIOUtils.write((int)DateUtils.parseDateExpressionToInt((LocalDate)dateValues[index]), (OutputStream)baos);
                    continue;
                }
                ReadWriteIOUtils.write((int)0, (OutputStream)baos);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void encodeBitMap(Tablet tablet, ByteArrayOutputStream baos) {
        BitMap[] bitMaps = tablet.getBitMaps();
        if (bitMaps != null) {
            try (DataOutputStream dataOutputStream = new DataOutputStream(baos);){
                for (BitMap bitMap : bitMaps) {
                    boolean columnHasNull = bitMap != null && !bitMap.isAllUnmarked(tablet.getRowSize());
                    dataOutputStream.writeByte(BytesUtils.boolToByte((boolean)columnHasNull));
                    if (!columnHasNull) continue;
                    dataOutputStream.write(bitMap.getTruncatedByteArray(tablet.getRowSize()));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private ByteBuffer compressBuffer(ByteBuffer buffer) {
        if (this.compressionType != CompressionType.UNCOMPRESSED) {
            ICompressor compressor = ICompressor.getCompressor((CompressionType)this.compressionType);
            int uncompressedSize = buffer.remaining();
            byte[] compressed = new byte[compressor.getMaxBytesForCompression(uncompressedSize) + 4];
            try {
                int compressedLength = compressor.compress(buffer.array(), buffer.arrayOffset() + buffer.position(), uncompressedSize, compressed);
                buffer = ByteBuffer.wrap(compressed, 0, compressedLength + 4);
                buffer.position(compressedLength);
                buffer.putInt(uncompressedSize);
                buffer.rewind();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return buffer;
    }
}

