/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.info;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.jackrabbit.standalone.cli.CommandException;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Cat
implements Command {
    private String pathKey = "path";
    private String indexKey = "index";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String path = (String)ctx.get(this.pathKey);
        Item item = CommandHelper.getItem(ctx, path);
        if (item.isNode()) {
            this.printNode(ctx, (Node)item);
        } else {
            this.printProperty(ctx, (Property)item);
        }
        return false;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String path) {
        this.pathKey = path;
    }

    private void printNode(Context ctx, Node n) throws PathNotFoundException, CommandException, RepositoryException, IllegalStateException, IOException {
        if (n.isNodeType("nt:file")) {
            this.printValue(ctx, n.getNode("jcr:content").getProperty("jcr:data").getValue());
        } else if (n.isNodeType("nt:resource")) {
            this.printValue(ctx, n.getProperty("jcr:data").getValue());
        } else {
            throw new CommandException("exception.cat.unsupported.type", new String[]{n.getPrimaryNodeType().getName()});
        }
    }

    private void printProperty(Context ctx, Property p) throws CommandException, ValueFormatException, IllegalStateException, RepositoryException, IOException {
        String indexStr = (String)ctx.get(this.indexKey);
        int index = 0;
        if (indexStr != null) {
            index = Integer.parseInt(indexStr);
        }
        if (p.getDefinition().isMultiple()) {
            this.printValue(ctx, p.getValues()[index]);
        } else {
            this.printValue(ctx, p.getValue());
        }
    }

    private void printValue(Context ctx, Value value) throws ValueFormatException, IllegalStateException, RepositoryException, IOException {
        PrintWriter out = CommandHelper.getOutput(ctx);
        out.println();
        BufferedReader in = new BufferedReader(new StringReader(value.getString()));
        String str = null;
        while ((str = in.readLine()) != null) {
            out.println(str);
        }
    }

    public String getIndexKey() {
        return this.indexKey;
    }

    public void setIndexKey(String indexKey) {
        this.indexKey = indexKey;
    }
}

