/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetWriter;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.riot.rowset.rw.XMLResults;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class RowSetWriterXML
implements RowSetWriter {
    public static final Symbol xmlInstruction = SystemARQ.allocSymbol("xmlInstruction");
    public static final Symbol xmlStylesheet = SystemARQ.allocSymbol("xmlStylesheet");
    public static RowSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_XML)) {
            throw new ResultSetException("RowSetWriter for XML asked for a " + String.valueOf(lang));
        }
        return new RowSetWriterXML();
    };

    private RowSetWriterXML() {
    }

    @Override
    public void write(Writer out, RowSet resultSet, Context context2) {
        throw new UnsupportedOperationException("Writing XML results to a java.io.Writer. Use an OutputStream.");
    }

    @Override
    public void write(OutputStream outStream, boolean result, Context context2) {
        XMLOutputASK out = new XMLOutputASK(this, outStream);
        if (context2 != null && context2.isDefined(xmlInstruction)) {
            out.xmlInst = context2.isTrue(xmlInstruction);
        }
        if (context2 != null && context2.isDefined(xmlStylesheet)) {
            out.stylesheetURL = (String)context2.get(xmlStylesheet);
        }
        out.exec(result);
    }

    @Override
    public void write(OutputStream outStream, RowSet rs, Context context2) {
        XMLOutputRowSet xOut = new XMLOutputRowSet(outStream, context2);
        if (context2 != null && context2.isDefined(xmlInstruction)) {
            xOut.setXmlInst(context2.isTrue(xmlInstruction));
        }
        if (context2 != null && context2.isDefined(xmlStylesheet)) {
            xOut.setStylesheetURL((String)context2.get(xmlStylesheet));
        }
        xOut.start(rs);
        while (rs.hasNext()) {
            Binding qs = rs.next();
            xOut.start(qs);
            for (Var var : rs.getResultVars()) {
                Node node = qs.get(var);
                xOut.solution(var, node);
            }
            xOut.finish(qs);
        }
        xOut.finish(rs);
    }

    private class XMLOutputASK
    implements XMLResults {
        String stylesheetURL = null;
        IndentedWriter out;
        int bNodeCounter = 0;
        boolean xmlInst = true;

        public XMLOutputASK(RowSetWriterXML rowSetWriterXML, OutputStream outStream) {
            this(rowSetWriterXML, outStream, null);
        }

        public XMLOutputASK(RowSetWriterXML rowSetWriterXML, OutputStream outStream, String stylesheetURL) {
            this(rowSetWriterXML, new IndentedWriter(outStream), stylesheetURL);
        }

        public XMLOutputASK(RowSetWriterXML rowSetWriterXML, IndentedWriter indentedOut, String stylesheetURL) {
            this.out = indentedOut;
            this.stylesheetURL = stylesheetURL;
        }

        public void exec(boolean result) {
            if (this.xmlInst) {
                this.out.println("<?xml version=\"1.0\"?>");
            }
            if (this.stylesheetURL != null) {
                this.out.println("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.stylesheetURL + "\"?>");
            }
            this.out.println("<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\">");
            this.out.incIndent(2);
            this.out.println("<head>");
            this.out.incIndent(2);
            this.out.decIndent(2);
            this.out.println("</head>");
            if (result) {
                this.out.println("<boolean>true</boolean>");
            } else {
                this.out.println("<boolean>false</boolean>");
            }
            this.out.decIndent(2);
            this.out.println("</sparql>");
            this.out.flush();
        }
    }

    private static class XMLOutputRowSet {
        private static boolean outputExplicitUnbound = false;
        private int index = 0;
        private String stylesheetURL = null;
        private boolean xmlInst = true;
        private final IndentedWriter out;
        private int bNodeCounter = 0;
        private final NodeToLabel bNodeMap;

        private XMLOutputRowSet(OutputStream outStream, Context context2) {
            this(new IndentedWriter(outStream), context2);
        }

        private XMLOutputRowSet(IndentedWriter indentedOut, Context context2) {
            this.out = indentedOut;
            boolean outputGraphBNodeLabels = context2 != null && context2.isTrue(ARQ.outputGraphBNodeLabels);
            this.bNodeMap = outputGraphBNodeLabels ? SyntaxLabels.createNodeToLabelAsGiven() : SyntaxLabels.createNodeToLabel();
        }

        public void start(RowSet rs) {
            if (this.xmlInst) {
                this.out.println("<?xml version=\"1.0\"?>");
            }
            if (this.stylesheetURL != null) {
                this.out.print("<?xml-stylesheet type=\"text/xsl\" href=\"");
                this.out.print(this.stylesheetURL);
                this.out.println("\"?>");
            }
            this.out.print("<");
            this.out.print("sparql");
            this.out.print(" xmlns=\"");
            this.out.print("http://www.w3.org/2005/sparql-results#");
            this.out.println("\">");
            this.out.incIndent(2);
            this.out.print("<");
            this.out.print("head");
            this.out.println(">");
            for (Var var : rs.getResultVars()) {
                String n = var.getVarName();
                this.out.incIndent(2);
                this.out.print("<");
                this.out.print("variable");
                this.out.print(" ");
                this.out.print("name");
                this.out.print("=\"");
                this.out.print(n);
                this.out.print("\"");
                this.out.println("/>");
                this.out.decIndent(2);
            }
            this.out.print("</");
            this.out.print("head");
            this.out.println(">");
            this.out.decIndent(2);
            this.out.incIndent(2);
            this.out.print("<");
            this.out.print("results");
            this.out.println(">");
            this.out.incIndent(2);
        }

        public void finish(RowSet rs) {
            this.out.decIndent(2);
            this.out.print("</");
            this.out.print("results");
            this.out.println(">");
            this.out.decIndent(2);
            this.out.print("</");
            this.out.print("sparql");
            this.out.println(">");
            this.out.flush();
        }

        public void start(Binding qs) {
            this.out.print("<");
            this.out.print("result");
            this.out.println(">");
            ++this.index;
            this.out.incIndent(2);
        }

        public void finish(Binding qs) {
            this.out.decIndent(2);
            this.out.print("</");
            this.out.print("result");
            this.out.println(">");
        }

        public void solution(Var var, Node rdfNode) {
            if (rdfNode == null && !outputExplicitUnbound) {
                return;
            }
            if (rdfNode == null) {
                this.out.print("<");
                this.out.print("unbound");
                this.out.println("/>");
                return;
            }
            String varName = var.getVarName();
            this.out.print("<");
            this.out.print("binding");
            this.out.print(" name=\"");
            this.out.print(varName);
            this.out.println("\">");
            this.out.incIndent(2);
            this.printBindingValue(rdfNode);
            this.out.decIndent(2);
            this.out.print("</");
            this.out.print("binding");
            this.out.println(">");
        }

        private void printBindingValue(Node node) {
            if (node == null) {
                return;
            }
            if (node.isLiteral()) {
                this.printLiteral(node);
                return;
            }
            if (node.isURI()) {
                this.printURI(node);
                return;
            }
            if (node.isBlank()) {
                this.printBlankNode(node);
                return;
            }
            if (node.isTripleTerm()) {
                this.printTripleTerm(node);
                return;
            }
            if (node.isNodeGraph()) {
                throw new UnsupportedOperationException("Graph terms");
            }
            Log.warn(this, "Unknown RDFNode type in result set: " + String.valueOf(node));
        }

        private void printURI(Node nodeURI) {
            String uri = nodeURI.getURI();
            this.out.print("<");
            this.out.print("uri");
            this.out.print(">");
            this.out.print(XMLOutputRowSet.xml_escape(uri));
            this.out.print("</");
            this.out.print("uri");
            this.out.println(">");
        }

        private void printBlankNode(Node node) {
            String label = (String)this.bNodeMap.get(null, node);
            label = label.substring(2);
            this.out.print("<");
            this.out.print("bnode");
            this.out.print(">");
            this.out.print(XMLOutputRowSet.xml_escape(label));
            this.out.print("</");
            this.out.print("bnode");
            this.out.println(">");
        }

        private void printLiteral(Node literal) {
            this.out.print("<");
            this.out.print("literal");
            if (Util.isLangString(literal) || Util.isDirLangString(literal)) {
                String lang = literal.getLiteralLanguage();
                if (Util.isDirLangString(literal)) {
                    this.out.print(" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\"");
                    this.out.println();
                    this.out.print("        ");
                }
                this.out.print(" xml:lang=\"");
                this.out.print(lang);
                this.out.print("\"");
                if (Util.isDirLangString(literal)) {
                    this.out.print(" its:dir=\"");
                    this.out.print(literal.getLiteralBaseDirection().direction());
                    this.out.print("\"");
                }
            } else if (!Util.isSimpleString(literal)) {
                String datatype = literal.getLiteralDatatypeURI();
                this.out.print(" ");
                this.out.print("datatype");
                this.out.print("=\"");
                this.out.print(datatype);
                this.out.print("\"");
            }
            this.out.print(">");
            this.out.print(XMLOutputRowSet.xml_escape(literal.getLiteralLexicalForm()));
            this.out.print("</");
            this.out.print("literal");
            this.out.println(">");
        }

        private void printTripleTerm(Node node) {
            Triple triple = node.getTriple();
            this.openTag("triple");
            this.openTag("subject");
            this.printBindingValue(triple.getSubject());
            this.closeTag("subject");
            this.openTag("predicate");
            this.printBindingValue(triple.getPredicate());
            this.closeTag("predicate");
            this.openTag("object");
            this.printBindingValue(triple.getObject());
            this.closeTag("object");
            this.closeTag("triple");
        }

        private void openTag(String name) {
            this.out.print("<");
            this.out.print(name);
            this.out.println(">");
            this.out.incIndent();
        }

        private void closeTag(String name) {
            this.out.decIndent();
            this.out.print("</");
            this.out.print(name);
            this.out.println(">");
        }

        private static String xml_escape(String string) {
            StringBuilder sb = new StringBuilder(string);
            int offset = 0;
            for (int i = 0; i < string.length(); ++i) {
                String replacement;
                char found = string.charAt(i);
                if (found < ' ') {
                    replacement = String.format("&#x%04X;", found);
                } else {
                    switch (found) {
                        case '&': {
                            replacement = "&amp;";
                            break;
                        }
                        case '<': {
                            replacement = "&lt;";
                            break;
                        }
                        case '>': {
                            replacement = "&gt;";
                            break;
                        }
                        case '\r': {
                            replacement = "&#x0D;";
                            break;
                        }
                        case '\n': {
                            replacement = "&#x0A;";
                            break;
                        }
                        default: {
                            replacement = null;
                        }
                    }
                }
                if (replacement == null) continue;
                sb.replace(offset + i, offset + i + 1, replacement);
                offset += replacement.length() - 1;
            }
            return sb.toString();
        }

        public String getStylesheetURL() {
            return this.stylesheetURL;
        }

        public void setStylesheetURL(String stylesheetURL) {
            this.stylesheetURL = stylesheetURL;
        }

        public boolean getXmlInst() {
            return this.xmlInst;
        }

        public void setXmlInst(boolean xmlInst) {
            this.xmlInst = xmlInst;
        }
    }
}

