/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.metadata.internal.Resources;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.quality.Element;

final class SpecialCases
extends PropertyAccessor {
    private final int westBoundLongitude;
    private final int eastBoundLongitude;
    private final int southBoundLatitude;
    private final int northBoundLatitude;

    SpecialCases(Class<?> type, Class<?> implementation, Class<?> standardImpl) {
        super(type, implementation, standardImpl);
        assert (SpecialCases.isSpecialCase(type)) : type;
        this.westBoundLongitude = this.indexOf("westBoundLongitude", true);
        this.eastBoundLongitude = this.indexOf("eastBoundLongitude", true);
        this.southBoundLatitude = this.indexOf("southBoundLatitude", true);
        this.northBoundLatitude = this.indexOf("northBoundLatitude", true);
    }

    static boolean isSpecialCase(Class<?> type) {
        return type == GeographicBoundingBox.class;
    }

    static boolean exclude(Class<?> type, String method) {
        return method.equals("getMeasure") && Element.class.isAssignableFrom(type);
    }

    @Override
    Class<?> type(int index, TypeValuePolicy policy) {
        Class<Object> type = super.type(index, policy);
        switch (policy) {
            case PROPERTY_TYPE: 
            case ELEMENT_TYPE: {
                if (index == this.westBoundLongitude || index == this.eastBoundLongitude) {
                    type = Longitude.class;
                    break;
                }
                if (index != this.southBoundLatitude && index != this.northBoundLatitude) break;
                type = Latitude.class;
            }
        }
        return type;
    }

    @Override
    CharSequence remarks(int index, Object metadata) {
        Object west;
        Object east;
        if (index == this.eastBoundLongitude && (east = super.get(index, metadata)) != null && (west = super.get(this.westBoundLongitude, metadata)) != null && Longitude.isWraparound((Double)west, (Double)east)) {
            return Resources.formatInternational((short)3);
        }
        return super.remarks(index, metadata);
    }

    @Override
    Object get(int index, Object metadata) throws BackingStoreException {
        Object value = super.get(index, metadata);
        if (value != null) {
            if (index == this.westBoundLongitude || index == this.eastBoundLongitude) {
                double angle = (Double)value;
                value = Double.isNaN(angle) ? null : new Longitude(angle);
            } else if (index == this.southBoundLatitude || index == this.northBoundLatitude) {
                double angle = (Double)value;
                value = Double.isNaN(angle) ? null : new Latitude(angle);
            }
        }
        return value;
    }

    @Override
    Object set(int index, Object metadata, Object value, int mode) throws UnmodifiableMetadataException, ClassCastException, BackingStoreException {
        if (index == this.westBoundLongitude || index == this.eastBoundLongitude) {
            if (value instanceof Longitude) {
                value = ((Longitude)value).degrees();
            }
            if ((value = super.set(index, metadata, value, mode)) != null) {
                value = new Longitude((Double)value);
            }
            return value;
        }
        if (index == this.southBoundLatitude || index == this.northBoundLatitude) {
            if (value instanceof Latitude) {
                value = ((Latitude)value).degrees();
            }
            if ((value = super.set(index, metadata, value, mode)) != null) {
                value = new Latitude((Double)value);
            }
            return value;
        }
        return super.set(index, metadata, value, mode);
    }

    static boolean isLocaleAndCharset(PropertyAccessor accessor, int indexInData) {
        return accessor.isMap(indexInData) && accessor.type.getName().startsWith("org.opengis.metadata.") && "localesAndCharsets".equals(accessor.name(indexInData, KeyNamePolicy.JAVABEANS_PROPERTY));
    }

    static String rename(String name) {
        if ("defaultLocale+otherLocale".equals(name)) {
            return "locale";
        }
        return name;
    }
}

