/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AbstractConfigurableComponent;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;

public abstract class AbstractReportingTask
extends AbstractConfigurableComponent
implements ReportingTask {
    private String identifier;
    private String name;
    private long schedulingNanos;
    private ControllerServiceLookup serviceLookup;
    private ComponentLog logger;
    private NodeTypeProvider nodeTypeProvider;

    @Override
    public final void initialize(ReportingInitializationContext config) throws InitializationException {
        this.identifier = config.getIdentifier();
        this.logger = config.getLogger();
        this.name = config.getName();
        this.schedulingNanos = config.getSchedulingPeriod(TimeUnit.NANOSECONDS);
        this.serviceLookup = config.getControllerServiceLookup();
        this.nodeTypeProvider = config.getNodeTypeProvider();
        this.init(config);
    }

    protected final ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceLookup;
    }

    protected final NodeTypeProvider getNodeTypeProvider() {
        return this.nodeTypeProvider;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    protected String getName() {
        return this.name;
    }

    @OnScheduled
    public void setComponentInfo(ConfigurationContext context) {
        this.name = context.getName();
    }

    protected long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos, TimeUnit.NANOSECONDS);
    }

    protected void init(ReportingInitializationContext config) throws InitializationException {
    }

    protected ComponentLog getLogger() {
        return this.logger;
    }
}

