/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.nifi.minifi.bootstrap.BootstrapRequest;
import org.apache.nifi.minifi.bootstrap.LimitingInputStream;

public class BootstrapRequestReader {
    private final String secretKey;

    public BootstrapRequestReader(String secretKey) {
        this.secretKey = secretKey;
    }

    public BootstrapRequest readRequest(InputStream in) throws IOException {
        LimitingInputStream limitingIn = new LimitingInputStream(in, 4096L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(limitingIn));
        String line = reader.readLine();
        String[] splits = line.split(" ");
        if (splits.length < 1) {
            throw new IOException("Received invalid request from Bootstrap: " + line);
        }
        String requestType = splits[0];
        if (splits.length == 1) {
            throw new IOException("Received invalid request from Bootstrap; request did not have a secret key; request type = " + requestType);
        }
        String[] args = splits.length == 2 ? new String[]{} : Arrays.copyOfRange(splits, 2, splits.length);
        String requestKey = splits[1];
        if (!this.secretKey.equals(requestKey)) {
            throw new IOException("Received invalid Secret Key for request type " + requestType);
        }
        try {
            return new BootstrapRequest(requestType, args);
        }
        catch (Exception e) {
            throw new IOException("Received invalid request from Bootstrap; request type = " + requestType);
        }
    }
}

