/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ui;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.ui.HtmlTemplates;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultLoginPageGeneratingFilter
extends GenericFilterBean {
    public static final String DEFAULT_LOGIN_PAGE_URL = "/login";
    public static final String ERROR_PARAMETER_NAME = "error";
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private @Nullable String loginPageUrl;
    private @Nullable String logoutSuccessUrl;
    private @Nullable String failureUrl;
    private boolean formLoginEnabled;
    private boolean oauth2LoginEnabled;
    private boolean saml2LoginEnabled;
    private boolean passkeysEnabled;
    private boolean oneTimeTokenEnabled;
    private @Nullable String authenticationUrl;
    private @Nullable String generateOneTimeTokenUrl;
    private @Nullable String usernameParameter;
    private @Nullable String passwordParameter;
    private @Nullable String rememberMeParameter;
    private final String factorTypeParameter = "factor.type";
    private final String factorReasonParameter = "factor.reason";
    private final List<String> allowedParameters = List.of(this.factorTypeParameter, this.factorReasonParameter);
    private Map<String, String> oauth2AuthenticationUrlToClientName;
    private Map<String, String> saml2AuthenticationUrlToProviderName;
    private Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs = request -> Collections.emptyMap();
    private Function<HttpServletRequest, Map<String, String>> resolveHeaders = request -> Collections.emptyMap();
    private static final String CSRF_HEADERS = "{\"{{headerName}}\" : \"{{headerValue}}\"}";
    private static final String PASSKEY_SCRIPT_TEMPLATE = "\t<script type=\"text/javascript\" src=\"{{contextPath}}/login/webauthn.js\"></script>\n\t<script type=\"text/javascript\">\n\t<!--\n\t\tdocument.addEventListener(\"DOMContentLoaded\",() => setupLogin({{csrfHeaders}}, \"{{contextPath}}\", document.getElementById('passkey-signin')));\n\n\t//-->\n\t</script>\n";
    private static final String PASSKEY_FORM_TEMPLATE = "<div class=\"login-form\">\n<h2>Login with Passkeys</h2>\n<button id=\"passkey-signin\" type=\"submit\" class=\"primary\">Sign in with a passkey</button>\n</div>\n";
    private static final String LOGIN_PAGE_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n    <title>Please sign in</title>\n    <link href=\"{{contextPath}}/default-ui.css\" rel=\"stylesheet\" />{{javaScript}}\n  </head>\n  <body>\n    <div class=\"content\">\n{{formLogin}}\n{{oneTimeTokenLogin}}{{passkeyLogin}}\n{{oauth2Login}}\n{{saml2Login}}\n    </div>\n  </body>\n</html>";
    private static final String LOGIN_FORM_TEMPLATE = "      <form class=\"login-form\" method=\"post\" action=\"{{loginUrl}}\">\n        <h2>Please sign in</h2>\n{{errorMessage}}{{logoutMessage}}\n        <p>\n          <label for=\"username\" class=\"screenreader\">Username</label>\n          {{usernameInput}}\n        </p>\n        <p>\n          <label for=\"password\" class=\"screenreader\">Password</label>\n          <input type=\"password\" id=\"password\" name=\"{{passwordParameter}}\" placeholder=\"Password\" {{autocomplete}}required>\n        </p>\n{{rememberMeInput}}\n{{hiddenInputs}}\n        <button type=\"submit\" class=\"primary\">Sign in</button>\n      </form>";
    private static final String FORM_READONLY_USERNAME_INPUT = "<input type=\"text\" id=\"username\" name=\"{{usernameParameter}}\" value=\"{{username}}\" placeholder=\"Username\" required readonly>\n";
    private static final String FORM_USERNAME_INPUT = "<input type=\"text\" id=\"username\" name=\"{{usernameParameter}}\" placeholder=\"Username\" required autofocus>\n";
    private static final String HIDDEN_HTML_INPUT_TEMPLATE = "<input name=\"{{name}}\" type=\"hidden\" value=\"{{value}}\" />\n";
    private static final String ALERT_TEMPLATE = "<div class=\"alert alert-danger\" role=\"alert\">{{message}}</div>";
    private static final String OAUTH2_LOGIN_TEMPLATE = "<h2>Login with OAuth 2.0</h2>\n{{errorMessage}}{{logoutMessage}}\n<table class=\"table table-striped\">\n  {{oauth2Rows}}\n</table>";
    private static final String OAUTH2_ROW_TEMPLATE = "<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>";
    private static final String SAML_LOGIN_TEMPLATE = "<h2>Login with SAML 2.0</h2>\n{{errorMessage}}{{logoutMessage}}\n<table class=\"table table-striped\">\n  {{samlRows}}\n</table>";
    private static final String SAML_ROW_TEMPLATE = "<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>";
    private static final String ONE_TIME_TEMPLATE = "      <form id=\"ott-form\" class=\"login-form\" method=\"post\" action=\"{{generateOneTimeTokenUrl}}\">\n        <h2>Request a One-Time Token</h2>\n{{errorMessage}}{{logoutMessage}}\n        <p>\n          <label for=\"ott-username\" class=\"screenreader\">Username</label>\n          {{usernameInput}}\n        </p>\n{{hiddenInputs}}\n        <button class=\"primary\" type=\"submit\" form=\"ott-form\">Send Token</button>\n      </form>\n";
    private static final String ONE_TIME_READONLY_USERNAME_INPUT = "<input type=\"text\" id=\"ott-username\" name=\"username\" value=\"{{username}}\" placeholder=\"Username\" required readonly>\n";
    private static final String ONE_TIME_USERNAME_INPUT = "<input type=\"text\" id=\"ott-username\" name=\"username\" placeholder=\"Username\" required>\n";

    public DefaultLoginPageGeneratingFilter() {
    }

    public DefaultLoginPageGeneratingFilter(UsernamePasswordAuthenticationFilter authFilter) {
        this.loginPageUrl = DEFAULT_LOGIN_PAGE_URL;
        this.logoutSuccessUrl = "/login?logout";
        this.failureUrl = "/login?error";
        if (authFilter != null) {
            this.initAuthFilter(authFilter);
        }
    }

    private void initAuthFilter(UsernamePasswordAuthenticationFilter authFilter) {
        this.formLoginEnabled = true;
        this.usernameParameter = authFilter.getUsernameParameter();
        this.passwordParameter = authFilter.getPasswordParameter();
        RememberMeServices rememberMeServices = authFilter.getRememberMeServices();
        if (rememberMeServices instanceof AbstractRememberMeServices) {
            AbstractRememberMeServices rememberMeServices2 = (AbstractRememberMeServices)rememberMeServices;
            this.rememberMeParameter = rememberMeServices2.getParameter();
        }
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public void setResolveHiddenInputs(Function<HttpServletRequest, Map<String, String>> resolveHiddenInputs) {
        Assert.notNull(resolveHiddenInputs, (String)"resolveHiddenInputs cannot be null");
        this.resolveHiddenInputs = resolveHiddenInputs;
    }

    public void setResolveHeaders(Function<HttpServletRequest, Map<String, String>> resolveHeaders) {
        Assert.notNull(resolveHeaders, (String)"resolveHeaders cannot be null");
        this.resolveHeaders = resolveHeaders;
    }

    public boolean isEnabled() {
        return this.formLoginEnabled || this.oauth2LoginEnabled || this.saml2LoginEnabled || this.oneTimeTokenEnabled;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public @Nullable String getLoginPageUrl() {
        return this.loginPageUrl;
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public void setFormLoginEnabled(boolean formLoginEnabled) {
        this.formLoginEnabled = formLoginEnabled;
    }

    public void setOauth2LoginEnabled(boolean oauth2LoginEnabled) {
        this.oauth2LoginEnabled = oauth2LoginEnabled;
    }

    public void setOneTimeTokenEnabled(boolean oneTimeTokenEnabled) {
        this.oneTimeTokenEnabled = oneTimeTokenEnabled;
    }

    public void setSaml2LoginEnabled(boolean saml2LoginEnabled) {
        this.saml2LoginEnabled = saml2LoginEnabled;
    }

    public void setPasskeysEnabled(boolean passkeysEnabled) {
        this.passkeysEnabled = passkeysEnabled;
    }

    public void setAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
    }

    public void setOneTimeTokenGenerationUrl(String generateOneTimeTokenUrl) {
        this.generateOneTimeTokenUrl = generateOneTimeTokenUrl;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setRememberMeParameter(String rememberMeParameter) {
        this.rememberMeParameter = rememberMeParameter;
    }

    public void setOauth2AuthenticationUrlToClientName(Map<String, String> oauth2AuthenticationUrlToClientName) {
        this.oauth2AuthenticationUrlToClientName = oauth2AuthenticationUrlToClientName;
    }

    public void setSaml2AuthenticationUrlToProviderName(Map<String, String> saml2AuthenticationUrlToProviderName) {
        this.saml2AuthenticationUrlToProviderName = saml2AuthenticationUrlToProviderName;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean loginError = this.isErrorPage(request);
        boolean logoutSuccess = this.isLogoutSuccess(request);
        if (this.isLoginUrlRequest(request) || loginError || logoutSuccess) {
            String loginPageHtml = this.generateLoginPageHtml(request, loginError, logoutSuccess);
            response.setContentType("text/html;charset=UTF-8");
            response.setContentLength(loginPageHtml.getBytes(StandardCharsets.UTF_8).length);
            response.getWriter().write(loginPageHtml);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String generateLoginPageHtml(HttpServletRequest request, boolean loginError, boolean logoutSuccess) {
        String errorMsg = "Invalid credentials";
        String contextPath = request.getContextPath();
        HtmlTemplates.Builder builder = HtmlTemplates.fromTemplate(LOGIN_PAGE_TEMPLATE).withRawHtml("contextPath", contextPath).withRawHtml("javaScript", "").withRawHtml("formLogin", "").withRawHtml("oneTimeTokenLogin", "").withRawHtml("oauth2Login", "").withRawHtml("saml2Login", "").withRawHtml("passkeyLogin", "");
        Predicate<String> wantsAuthority = this.wantsAuthority(request);
        if (wantsAuthority.test("webauthn")) {
            builder.withRawHtml("javaScript", this.renderJavaScript(request, contextPath)).withRawHtml("passkeyLogin", this.renderPasskeyLogin());
        }
        if (wantsAuthority.test("password")) {
            builder.withRawHtml("formLogin", this.renderFormLogin(request, loginError, logoutSuccess, contextPath, errorMsg));
        }
        if (wantsAuthority.test("ott")) {
            builder.withRawHtml("oneTimeTokenLogin", this.renderOneTimeTokenLogin(request, loginError, logoutSuccess, contextPath, errorMsg));
        }
        if (wantsAuthority.test("authorization_code")) {
            builder.withRawHtml("oauth2Login", this.renderOAuth2Login(loginError, logoutSuccess, errorMsg, contextPath));
        }
        if (wantsAuthority.test("saml_response")) {
            builder.withRawHtml("saml2Login", this.renderSaml2Login(loginError, logoutSuccess, errorMsg, contextPath));
        }
        return builder.render();
    }

    private Predicate<String> wantsAuthority(HttpServletRequest request) {
        String[] authorities = request.getParameterValues(this.factorTypeParameter);
        if (authorities == null) {
            return authority -> true;
        }
        return List.of(authorities)::contains;
    }

    private String renderJavaScript(HttpServletRequest request, String contextPath) {
        if (this.passkeysEnabled) {
            return HtmlTemplates.fromTemplate(PASSKEY_SCRIPT_TEMPLATE).withValue("loginPageUrl", this.loginPageUrl).withValue("contextPath", contextPath).withRawHtml("csrfHeaders", this.renderHeaders(request)).render();
        }
        return "";
    }

    private String renderPasskeyLogin() {
        if (this.passkeysEnabled) {
            return PASSKEY_FORM_TEMPLATE;
        }
        return "";
    }

    private String renderHeaders(HttpServletRequest request) {
        StringBuffer javascriptHeadersEntries = new StringBuffer();
        Map<String, String> headers = this.resolveHeaders.apply(request);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            javascriptHeadersEntries.append(HtmlTemplates.fromTemplate(CSRF_HEADERS).withValue("headerName", header.getKey()).withValue("headerValue", header.getValue()).render());
        }
        return javascriptHeadersEntries.toString();
    }

    private String renderFormLogin(HttpServletRequest request, boolean loginError, boolean logoutSuccess, String contextPath, String errorMsg) {
        if (!this.formLoginEnabled) {
            return "";
        }
        String username = this.getUsername();
        String usernameInput = (username != null ? HtmlTemplates.fromTemplate(FORM_READONLY_USERNAME_INPUT).withValue("username", username) : HtmlTemplates.fromTemplate(FORM_USERNAME_INPUT)).withValue("usernameParameter", this.usernameParameter).render();
        String hiddenInputs = this.resolveHiddenInputs.apply(request).entrySet().stream().map(inputKeyValue -> this.renderHiddenInput((String)inputKeyValue.getKey(), (String)inputKeyValue.getValue())).collect(Collectors.joining("\n"));
        return HtmlTemplates.fromTemplate(LOGIN_FORM_TEMPLATE).withValue("loginUrl", contextPath + this.authenticationUrl).withRawHtml("errorMessage", this.renderError(loginError, errorMsg)).withRawHtml("logoutMessage", this.renderSuccess(logoutSuccess)).withRawHtml("usernameInput", usernameInput).withValue("passwordParameter", this.passwordParameter).withRawHtml("rememberMeInput", this.renderRememberMe(this.rememberMeParameter)).withRawHtml("hiddenInputs", hiddenInputs).withRawHtml("autocomplete", this.passkeysEnabled ? "autocomplete=\"password webauthn\" " : "").render();
    }

    private String renderOneTimeTokenLogin(HttpServletRequest request, boolean loginError, boolean logoutSuccess, String contextPath, String errorMsg) {
        if (!this.oneTimeTokenEnabled) {
            return "";
        }
        String hiddenInputs = this.resolveHiddenInputs.apply(request).entrySet().stream().map(inputKeyValue -> this.renderHiddenInput((String)inputKeyValue.getKey(), (String)inputKeyValue.getValue())).collect(Collectors.joining("\n"));
        String username = this.getUsername();
        String usernameInput = username != null ? HtmlTemplates.fromTemplate(ONE_TIME_READONLY_USERNAME_INPUT).withValue("username", username).render() : ONE_TIME_USERNAME_INPUT;
        return HtmlTemplates.fromTemplate(ONE_TIME_TEMPLATE).withValue("generateOneTimeTokenUrl", contextPath + this.generateOneTimeTokenUrl).withRawHtml("errorMessage", this.renderError(loginError, errorMsg)).withRawHtml("logoutMessage", this.renderSuccess(logoutSuccess)).withRawHtml("hiddenInputs", hiddenInputs).withRawHtml("usernameInput", usernameInput).render();
    }

    private String renderOAuth2Login(boolean loginError, boolean logoutSuccess, String errorMsg, String contextPath) {
        if (!this.oauth2LoginEnabled) {
            return "";
        }
        String oauth2Rows = this.oauth2AuthenticationUrlToClientName.entrySet().stream().map(urlToName -> DefaultLoginPageGeneratingFilter.renderOAuth2Row(contextPath, (String)urlToName.getKey(), (String)urlToName.getValue())).collect(Collectors.joining("\n"));
        return HtmlTemplates.fromTemplate(OAUTH2_LOGIN_TEMPLATE).withRawHtml("errorMessage", this.renderError(loginError, errorMsg)).withRawHtml("logoutMessage", this.renderSuccess(logoutSuccess)).withRawHtml("oauth2Rows", oauth2Rows).render();
    }

    private static String renderOAuth2Row(String contextPath, String url, String clientName) {
        return HtmlTemplates.fromTemplate("<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>").withValue("url", contextPath + url).withValue("clientName", clientName).render();
    }

    private String renderSaml2Login(boolean loginError, boolean logoutSuccess, String errorMsg, String contextPath) {
        if (!this.saml2LoginEnabled) {
            return "";
        }
        String samlRows = this.saml2AuthenticationUrlToProviderName.entrySet().stream().map(urlToName -> DefaultLoginPageGeneratingFilter.renderSaml2Row(contextPath, (String)urlToName.getKey(), (String)urlToName.getValue())).collect(Collectors.joining("\n"));
        return HtmlTemplates.fromTemplate(SAML_LOGIN_TEMPLATE).withRawHtml("errorMessage", this.renderError(loginError, errorMsg)).withRawHtml("logoutMessage", this.renderSuccess(logoutSuccess)).withRawHtml("samlRows", samlRows).render();
    }

    private static String renderSaml2Row(String contextPath, String url, String clientName) {
        return HtmlTemplates.fromTemplate("<tr><td><a href=\"{{url}}\">{{clientName}}</a></td></tr>").withValue("url", contextPath + url).withValue("clientName", clientName).render();
    }

    private String renderHiddenInput(String name, String value) {
        return HtmlTemplates.fromTemplate(HIDDEN_HTML_INPUT_TEMPLATE).withValue("name", name).withValue("value", value).render();
    }

    private String renderRememberMe(@Nullable String paramName) {
        if (paramName == null) {
            return "";
        }
        return HtmlTemplates.fromTemplate("<p><input type='checkbox' name='{{paramName}}'/> Remember me on this computer.</p>").withValue("paramName", paramName).render();
    }

    private @Nullable String getUsername() {
        Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return authentication.getName();
        }
        return null;
    }

    private boolean isLogoutSuccess(HttpServletRequest request) {
        return this.logoutSuccessUrl != null && this.matches(request, this.logoutSuccessUrl);
    }

    private boolean isLoginUrlRequest(HttpServletRequest request) {
        return this.matches(request, this.loginPageUrl);
    }

    private boolean isErrorPage(HttpServletRequest request) {
        return this.matches(request, this.failureUrl);
    }

    private String renderError(boolean isError, String message) {
        if (!isError) {
            return "";
        }
        return HtmlTemplates.fromTemplate(ALERT_TEMPLATE).withValue("message", message).render();
    }

    private String renderSuccess(boolean isLogoutSuccess) {
        if (!isLogoutSuccess) {
            return "";
        }
        return "<div class=\"alert alert-success\" role=\"alert\">You have been signed out</div>";
    }

    private boolean matches(HttpServletRequest request, @Nullable String url) {
        if (!"GET".equals(request.getMethod()) || url == null) {
            return false;
        }
        Object uri = request.getRequestURI();
        int pathParamIndex = ((String)uri).indexOf(59);
        if (pathParamIndex > 0) {
            uri = ((String)uri).substring(0, pathParamIndex);
        }
        if (request.getQueryString() != null) {
            uri = (String)uri + "?" + request.getQueryString();
        }
        UriComponentsBuilder addAllowed = UriComponentsBuilder.fromUriString((String)url);
        for (String parameter : this.allowedParameters) {
            String[] values = request.getParameterValues(parameter);
            if (values == null) continue;
            for (String value : values) {
                addAllowed.queryParam(parameter, new Object[]{value});
            }
        }
        if ("".equals(request.getContextPath())) {
            return ((String)uri).equals(addAllowed.toUriString());
        }
        return ((String)uri).equals(request.getContextPath() + addAllowed.toUriString());
    }
}

