/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License") you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *******************************************************************************/
package org.apache.ofbiz.widget.renderer;

import java.io.IOException;
import java.util.Map;

import org.apache.ofbiz.widget.model.CommonWidgetModels.Image;
import org.apache.ofbiz.widget.model.ModelMenu;
import org.apache.ofbiz.widget.model.ModelMenuItem;


/**
 * Widget Library - Form String Renderer interface
 */
public interface MenuStringRenderer {
    void renderMenuItem(Appendable writer, Map<String, Object> context, ModelMenuItem menuItem) throws IOException;
    void renderMenuOpen(Appendable writer, Map<String, Object> context, ModelMenu menu) throws IOException;
    void renderMenuClose(Appendable writer, Map<String, Object> context, ModelMenu menu) throws IOException;
    void renderFormatSimpleWrapperOpen(Appendable writer, Map<String, Object> context, ModelMenu menu) throws IOException;
    void renderFormatSimpleWrapperClose(Appendable writer, Map<String, Object> context, ModelMenu menu) throws IOException;
    void renderFormatSimpleWrapperRows(Appendable writer, Map<String, Object> context, Object menu) throws IOException;
    void renderLink(Appendable writer, Map<String, Object> context, ModelMenuItem.MenuLink link) throws IOException;
    void renderImage(Appendable writer, Map<String, Object> context, Image image) throws IOException;
}
