/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public final class ModelParameterChunker {
    public static final String SIGNATURE_CHUNKED_PARAMS = "CHUNKED-MODEL-PARAMS:";
    private static final int MAX_CHUNK_SIZE_BYTES = 65535;

    private ModelParameterChunker() {
    }

    public static String readUTF(DataInputStream dis) throws IOException {
        String data = dis.readUTF();
        if (data.startsWith(SIGNATURE_CHUNKED_PARAMS)) {
            String chunkElements = data.replace(SIGNATURE_CHUNKED_PARAMS, "");
            int chunkSize = Integer.parseInt(chunkElements);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < chunkSize; ++i) {
                sb.append(dis.readUTF());
            }
            return sb.toString();
        }
        return data;
    }

    public static void writeUTF(DataOutputStream dos, String s) throws IOException {
        try {
            dos.writeUTF(s);
        }
        catch (UTFDataFormatException dfe) {
            String[] chunks = ModelParameterChunker.splitByByteLength(s);
            dos.writeUTF(SIGNATURE_CHUNKED_PARAMS + chunks.length);
            for (String c : chunks) {
                dos.writeUTF(c);
            }
        }
    }

    private static String[] splitByByteLength(String input) {
        CoderResult cr;
        CharBuffer in = CharBuffer.wrap(input);
        ByteBuffer out = ByteBuffer.allocate(65535);
        CharsetEncoder coder = StandardCharsets.UTF_8.newEncoder();
        ArrayList<String> chunks = new ArrayList<String>();
        int pos = 0;
        do {
            cr = coder.encode(in, out, true);
            int nPos = input.length() - in.length();
            String s = input.substring(pos, nPos);
            chunks.add(s);
            pos = nPos;
            out.rewind();
        } while (cr.isOverflow());
        return chunks.toArray(new String[0]);
    }
}

