/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.rest.RequestInfo;
import org.apache.qpid.server.model.ConfiguredObject;

public class RequestInfoParser {
    private static final String USER_PREFERENCES = "userpreferences";
    private static final String VISIBLE_USER_PREFERENCES = "visiblepreferences";
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private final List<Class<? extends ConfiguredObject>> _hierarchy;

    public RequestInfoParser(Class<? extends ConfiguredObject> ... hierarchy) {
        this._hierarchy = Arrays.asList(hierarchy);
    }

    public RequestInfo parse(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo() != null ? request.getPathInfo() : "";
        List<String> parts = HttpManagementUtil.getPathInfoElements(servletPath, pathInfo);
        Map<String, List<String>> queryParameters = this.parseQueryString(request.getQueryString());
        String method = request.getMethod();
        if ("POST".equals(method)) {
            return this.parsePost(servletPath, pathInfo, parts, queryParameters);
        }
        if ("PUT".equals(method)) {
            return this.parsePut(servletPath, pathInfo, parts, queryParameters);
        }
        if ("GET".equals(method)) {
            return this.parseGet(servletPath, pathInfo, parts, queryParameters);
        }
        if ("DELETE".equals(method)) {
            return this.parseDelete(servletPath, pathInfo, parts, queryParameters);
        }
        throw new IllegalArgumentException(String.format("Unexpected method type '%s' for path '%s%s'", method, servletPath, pathInfo));
    }

    private RequestInfo parseDelete(String servletPath, String pathInfo, List<String> parts, Map<String, List<String>> queryParameters) {
        if (parts.size() <= this._hierarchy.size()) {
            return RequestInfo.createModelRequestInfo(parts, queryParameters, parts.size() == this._hierarchy.size());
        }
        if (parts.size() > this._hierarchy.size() && USER_PREFERENCES.equals(parts.get(this._hierarchy.size()))) {
            return RequestInfo.createPreferencesRequestInfo(parts.subList(0, this._hierarchy.size()), parts.subList(this._hierarchy.size() + 1, parts.size()), queryParameters);
        }
        String expectedPath = this.buildExpectedPath(servletPath, this._hierarchy);
        throw new IllegalArgumentException(String.format("Invalid DELETE path '%s%s'. Expected: '%s' or '%s/userpreferences[/<preference type>[/<preference name>]]'", servletPath, pathInfo, expectedPath, expectedPath));
    }

    private RequestInfo parseGet(String servletPath, String pathInfo, List<String> parts, Map<String, List<String>> queryParameters) {
        if (parts.size() <= this._hierarchy.size()) {
            return RequestInfo.createModelRequestInfo(parts, queryParameters, parts.size() == this._hierarchy.size());
        }
        if (parts.size() > this._hierarchy.size()) {
            if (USER_PREFERENCES.equals(parts.get(this._hierarchy.size()))) {
                return RequestInfo.createPreferencesRequestInfo(parts.subList(0, this._hierarchy.size()), parts.subList(this._hierarchy.size() + 1, parts.size()), queryParameters);
            }
            if (VISIBLE_USER_PREFERENCES.equals(parts.get(this._hierarchy.size()))) {
                return RequestInfo.createVisiblePreferencesRequestInfo(parts.subList(0, this._hierarchy.size()), parts.subList(this._hierarchy.size() + 1, parts.size()), queryParameters);
            }
            if (parts.size() == this._hierarchy.size() + 1) {
                return RequestInfo.createOperationRequestInfo(parts.subList(0, this._hierarchy.size()), parts.get(parts.size() - 1), queryParameters);
            }
        }
        String expectedPath = this.buildExpectedPath(servletPath, this._hierarchy);
        throw new IllegalArgumentException(String.format("Invalid GET path '%s%s'. Expected: '%s[/<operation name>]'", servletPath, pathInfo, expectedPath));
    }

    private RequestInfo parsePut(String servletPath, String pathInfo, List<String> parts, Map<String, List<String>> queryParameters) {
        if (parts.size() == this._hierarchy.size() || parts.size() == this._hierarchy.size() - 1) {
            return RequestInfo.createModelRequestInfo(parts, queryParameters, parts.size() == this._hierarchy.size());
        }
        if (parts.size() > this._hierarchy.size() && USER_PREFERENCES.equals(parts.get(this._hierarchy.size()))) {
            return RequestInfo.createPreferencesRequestInfo(parts.subList(0, this._hierarchy.size()), parts.subList(this._hierarchy.size() + 1, parts.size()), queryParameters);
        }
        String expectedPath = this.buildExpectedPath(servletPath, this._hierarchy);
        throw new IllegalArgumentException(String.format("Invalid PUT path '%s%s'. Expected: '%s'", servletPath, pathInfo, expectedPath));
    }

    private RequestInfo parsePost(String servletPath, String pathInfo, List<String> parts, Map<String, List<String>> queryParameters) {
        if (parts.size() == this._hierarchy.size() || parts.size() == this._hierarchy.size() - 1) {
            return RequestInfo.createModelRequestInfo(parts, queryParameters, parts.size() == this._hierarchy.size());
        }
        if (parts.size() > this._hierarchy.size()) {
            if (USER_PREFERENCES.equals(parts.get(this._hierarchy.size()))) {
                return RequestInfo.createPreferencesRequestInfo(parts.subList(0, this._hierarchy.size()), parts.subList(this._hierarchy.size() + 1, parts.size()), queryParameters);
            }
            if (parts.size() == this._hierarchy.size() + 1 && !VISIBLE_USER_PREFERENCES.equals(parts.get(this._hierarchy.size()))) {
                return RequestInfo.createOperationRequestInfo(parts.subList(0, this._hierarchy.size()), parts.get(parts.size() - 1), queryParameters);
            }
        }
        String expectedFullPath = this.buildExpectedPath(servletPath, this._hierarchy);
        String expectedParentPath = this.buildExpectedPath(servletPath, this._hierarchy.subList(0, this._hierarchy.size() - 1));
        throw new IllegalArgumentException(String.format("Invalid POST path '%s%s'. Expected: '%s/<operation name>' or '%s' or '%s/userpreferences[/<preference type>]'", servletPath, pathInfo, expectedFullPath, expectedParentPath, expectedFullPath));
    }

    private String buildExpectedPath(String servletPath, List<Class<? extends ConfiguredObject>> hierarchy) {
        StringBuilder expectedPath = new StringBuilder(servletPath);
        for (Class<? extends ConfiguredObject> part : hierarchy) {
            expectedPath.append("/<");
            expectedPath.append(part.getSimpleName().toLowerCase());
            expectedPath.append(" name>");
        }
        return expectedPath.toString();
    }

    private Map<String, List<String>> parseQueryString(String queryString) {
        LinkedHashMap<String, List<String>> query = new LinkedHashMap<String, List<String>>();
        if (queryString == null || queryString.isEmpty()) {
            return query;
        }
        List<String> pairs = Arrays.asList(queryString.split("&"));
        for (String pairString : pairs) {
            String value;
            String key;
            ArrayList<String> pair = new ArrayList<String>(Arrays.asList(pairString.split("=")));
            if (pair.size() == 1) {
                pair.add(null);
            } else if (pair.size() != 2) {
                throw new IllegalArgumentException(String.format("could not parse query string '%s'", queryString));
            }
            try {
                key = URLDecoder.decode((String)pair.get(0), UTF8);
                value = pair.get(1) == null ? null : URLDecoder.decode((String)pair.get(1), UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (!query.containsKey(key)) {
                query.put(key, new ArrayList());
            }
            ((List)query.get(key)).add(value);
        }
        return query;
    }
}

